//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * vfʒuwb_
 * @author Junpee
 */

#ifndef POINT_2I_H_
#define POINT_2I_H_

namespace Lamp{

class Point2f;

//------------------------------------------------------------------------------
/**
 * vfʒu
 *
 * ̃NX͌pȂŉB
 */
class Point2i{
public:
	//--------------------------------------------------------------------------
	// oϐ
	//--------------------------------------------------------------------------
	/// oϐ
	union{
		/// evf
		struct{
			/// Xl
			int x;
			/// Yl
			int y;
		};

		/// z
		int array[2];
	};

	//--------------------------------------------------------------------------
	// 萔
	//--------------------------------------------------------------------------
	/// [ʒu
	static const Point2i zero;

	/// Pʈʒu
	static const Point2i unit;

	//--------------------------------------------------------------------------
	// RXgN^
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 *
	 * ̃RXgN^͏l̐ݒsȂߒl͕słB
	 */
	Point2i(){}

	/**
	 * RXgN^
	 * @param sourceX Xl̏l
	 * @param sourceY Yl̏l
	 */
	Point2i(int sourceX, int sourceY) : x(sourceX), y(sourceY){}

	/**
	 * RXgN^
	 * @param sourceArray lz
	 */
	explicit Point2i(int sourceArray[2]) :
		x(sourceArray[0]), y(sourceArray[1]){}

	/**
	 * RXgN^
	 * @param source ʒu
	 */
	explicit Point2i(const Point2f& source);

	//--------------------------------------------------------------------------
	// l̐ݒ
	//--------------------------------------------------------------------------
	/**
	 * l̐ݒ
	 * @param sourceX Xl̐ݒl
	 * @param sourceY Yl̐ݒl
	 */
	inline void set(int sourceX, int sourceY){
		x = sourceX;
		y = sourceY;
	}

	/**
	 * l̐ݒ
	 * @param sourceArray ݒlz
	 */
	inline void set(int sourceArray[2]){
		x = sourceArray[0];
		y = sourceArray[1];
	}

	/**
	 * l̐ݒ
	 * @param source ݒ肷ʒu
	 */
	void set(const Point2f& source);

	//--------------------------------------------------------------------------
	// Z
	//--------------------------------------------------------------------------
	/**
	 * Z
	 * @param addPoint Zʒu
	 * @return Zꂽʒu
	 */
	inline Point2i operator +(const Point2i& addPoint) const{
		return Point2i(x + addPoint.x, y + addPoint.y);
	}

	/**
	 * Z
	 * @param subPoint Zʒu
	 * @return Zꂽʒu
	 */
	inline Point2i operator -(const Point2i& subPoint) const{
		return Point2i(x - subPoint.x, y - subPoint.y);
	}

	/**
	 * Z
	 * @param mulPoint Zʒu
	 * @return Zꂽʒu
	 */
	inline Point2i operator *(const Point2i& mulPoint) const{
		return Point2i(x * mulPoint.x, y * mulPoint.y);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return Zꂽʒu
	 */
	inline Point2i operator *(float mulValue) const{
		return Point2i((int)(x * mulValue), (int)(y * mulValue));
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @param mulPoint Zʒu
	 * @return Zꂽʒu
	 */
	inline friend Point2i operator *(float mulValue, const Point2i& mulPoint){
		return Point2i((int)(mulPoint.x * mulValue),
			(int)(mulPoint.y * mulValue));
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return Zꂽʒu
	 */
	inline Point2i operator *(int mulValue) const{
		return Point2i(x * mulValue, y * mulValue);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @param mulPoint Zʒu
	 * @return Zꂽʒu
	 */
	inline friend Point2i operator *(int mulValue, const Point2i& mulPoint){
		return Point2i(mulPoint.x * mulValue, mulPoint.y * mulValue);
	}

	/**
	 * +Zq
	 * @return ʒũRs[
	 */
	inline Point2i operator +() const{ return *this; }

	/**
	 * -Zq
	 * @return l̕]ʒu
	 */
	inline Point2i operator -() const{ return Point2i(-x, -y); }

	//--------------------------------------------------------------------------
	// Z
	//--------------------------------------------------------------------------
	/**
	 * Z
	 * @param addPoint Zʒu
	 * @return Zꂽʒu
	 */
	inline Point2i& operator +=(const Point2i& addPoint){
		x += addPoint.x;
		y += addPoint.y;
		return (*this);
	}

	/**
	 * Z
	 * @param subPoint Zʒu
	 * @return Zꂽʒu
	 */
	inline Point2i& operator -=(const Point2i& subPoint){
		x -= subPoint.x;
		y -= subPoint.y;
		return (*this);
	}

	/**
	 * Z
	 * @param mulPoint Zʒu
	 * @return Zꂽʒu
	 */
	inline Point2i& operator *=(const Point2i& mulPoint){
		x *= mulPoint.x;
		y *= mulPoint.y;
		return (*this);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return Zꂽʒu
	 */
	inline Point2i& operator *=(float mulValue){
		x = (int)(x * mulValue);
		y = (int)(y * mulValue);
		return (*this);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return Zꂽʒu
	 */
	inline Point2i& operator *=(int mulValue){
		x *= mulValue;
		y *= mulValue;
		return (*this);
	}

	//--------------------------------------------------------------------------
	// _Z
	//--------------------------------------------------------------------------
	/**
	 * lǂ
	 * @param target rʒu
	 * @return lłtrueԂ
	 */
	inline bool operator ==(const Point2i& target) const{
		return ((x == target.x) && (y == target.y));
	}

	/**
	 * lłȂǂ
	 * @param target rʒu
	 * @return lłȂtrueԂ
	 */
	inline bool operator !=(const Point2i& target) const{
		return ((x != target.x) || (y != target.y));
	}

	//--------------------------------------------------------------------------
	// ̑
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return ʒu̕\L
	 */
	inline String toString() const{
		String returnString;
		returnString.format("( %d, %d )", x, y);
		return returnString;
	}

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of POINT_2I_H_
//------------------------------------------------------------------------------
