//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * vfʒuwb_
 * @author Junpee
 */

#ifndef POINT_2F_H_
#define POINT_2F_H_

namespace Lamp{

class Point2i;

//------------------------------------------------------------------------------
/**
 * vfʒu
 *
 * ̃NX͌pȂŉB
 */
class Point2f{
public:
	//--------------------------------------------------------------------------
	// oϐ
	//--------------------------------------------------------------------------
	/// oϐ
	union{
		/// evf
		struct{
			/// Xl
			float x;
			/// Yl
			float y;
		};

		/// z
		float array[2];
	};

	//--------------------------------------------------------------------------
	// 萔
	//--------------------------------------------------------------------------
	/// [ʒu
	static const Point2f zero;

	/// Pʈʒu
	static const Point2f unit;

	//--------------------------------------------------------------------------
	// RXgN^
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 *
	 * ̃RXgN^͏l̐ݒsȂߒl͕słB
	 */
	Point2f(){}

	/**
	 * RXgN^
	 * @param sourceX Xl̏l
	 * @param sourceY Yl̏l
	 */
	Point2f(float sourceX, float sourceY) : x(sourceX), y(sourceY){}

	/**
	 * RXgN^
	 * @param sourceArray lz
	 */
	explicit Point2f(float sourceArray[2]) :
		x(sourceArray[0]), y(sourceArray[1]){}

	/**
	 * RXgN^
	 * @param source ʒu
	 */
	explicit Point2f(const Point2i& source);

	//--------------------------------------------------------------------------
	// l̐ݒ
	//--------------------------------------------------------------------------
	/**
	 * l̐ݒ
	 * @param sourceX Xl̐ݒl
	 * @param sourceY Yl̐ݒl
	 */
	inline void set(float sourceX, float sourceY){
		x = sourceX;
		y = sourceY;
	}

	/**
	 * l̐ݒ
	 * @param sourceArray ݒlz
	 */
	inline void set(float sourceArray[2]){
		x = sourceArray[0];
		y = sourceArray[1];
	}

	/**
	 * l̐ݒ
	 * @param source ݒ肷ʒu
	 */
	void set(const Point2i& source);

	//--------------------------------------------------------------------------
	// Z
	//--------------------------------------------------------------------------
	/**
	 * Z
	 * @param addPoint Zʒu
	 * @return Zꂽʒu
	 */
	inline Point2f operator +(const Point2f& addPoint) const{
		return Point2f(x + addPoint.x, y + addPoint.y);
	}

	/**
	 * Z
	 * @param subPoint Zʒu
	 * @return Zꂽʒu
	 */
	inline Point2f operator -(const Point2f& subPoint) const{
		return Point2f(x - subPoint.x, y - subPoint.y);
	}

	/**
	 * Z
	 * @param mulPoint Zʒu
	 * @return Zꂽʒu
	 */
	inline Point2f operator *(const Point2f& mulPoint) const{
		return Point2f(x * mulPoint.x, y * mulPoint.y);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return Zꂽʒu
	 */
	inline Point2f operator *(float mulValue) const{
		return Point2f(x * mulValue, y * mulValue);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @param mulPoint Zʒu
	 * @return Zꂽʒu
	 */
	inline friend Point2f operator *(float mulValue, const Point2f& mulPoint){
		return Point2f(mulPoint.x * mulValue, mulPoint.y * mulValue);
	}

	/**
	 * +Zq
	 * @return ʒũRs[
	 */
	inline Point2f operator +() const{ return *this; }

	/**
	 * -Zq
	 * @return l̕]ʒu
	 */
	inline Point2f operator -() const{ return Point2f(-x, -y); }

	//--------------------------------------------------------------------------
	// Z
	//--------------------------------------------------------------------------
	/**
	 * Z
	 * @param addPoint Zʒu
	 * @return Zꂽʒu
	 */
	inline Point2f& operator +=(const Point2f& addPoint){
		x += addPoint.x;
		y += addPoint.y;
		return (*this);
	}

	/**
	 * Z
	 * @param subPoint Zʒu
	 * @return Zꂽʒu
	 */
	inline Point2f& operator -=(const Point2f& subPoint){
		x -= subPoint.x;
		y -= subPoint.y;
		return (*this);
	}

	/**
	 * Z
	 * @param mulPoint Zʒu
	 * @return Zꂽʒu
	 */
	inline Point2f& operator *=(const Point2f& mulPoint){
		x *= mulPoint.x;
		y *= mulPoint.y;
		return (*this);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return Zꂽʒu
	 */
	inline Point2f& operator *=(float mulValue){
		x = x * mulValue;
		y = y * mulValue;
		return (*this);
	}

	//--------------------------------------------------------------------------
	// _Z
	//--------------------------------------------------------------------------
	/**
	 * lǂ
	 * @param target rʒu
	 * @return lłtrueԂ
	 */
	inline bool operator ==(const Point2f& target) const{
		return ((x == target.x) && (y == target.y));
	}

	/**
	 * lłȂǂ
	 * @param target rʒu
	 * @return lłȂtrueԂ
	 */
	inline bool operator !=(const Point2f& target) const{
		return ((x != target.x) || (y != target.y));
	}

	//--------------------------------------------------------------------------
	// ̑
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return ʒu̕\L
	 */
	inline String toString() const{
		String returnString;
		returnString.format("( %.8f, %.8f )", x, y);
		return returnString;
	}

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of POINT_2F_H_
//------------------------------------------------------------------------------
