//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * @wb_
 * @author Junpee
 */

#ifndef DIMENSION_I_H_
#define DIMENSION_I_H_

namespace Lamp{

class DimensionF;

//------------------------------------------------------------------------------
/**
 * @
 *
 * ̃NX͌pȂŉB
 */
class DimensionI{
public:
	//--------------------------------------------------------------------------
	// oϐ
	//--------------------------------------------------------------------------
	/// oϐ
	union{
		/// evf
		struct{
			/// 
			int width;
			/// 
			int height;
		};

		/// z
		int array[2];
	};

	//--------------------------------------------------------------------------
	// 萔
	//--------------------------------------------------------------------------
	/// [@
	static const DimensionI zero;

	/// Pʐ@
	static const DimensionI unit;

	//--------------------------------------------------------------------------
	// RXgN^
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 *
	 * ̃RXgN^͏l̐ݒsȂߒl͕słB
	 */
	DimensionI(){}

	/**
	 * RXgN^
	 * @param sourceWidth ̏l
	 * @param sourceHeight ̏l
	 */
	DimensionI(int sourceWidth, int sourceHeight) :
		width(sourceWidth), height(sourceHeight){}

	/**
	 * RXgN^
	 * @param sourceArray lz
	 */
	explicit DimensionI(int sourceArray[2]) :
		width(sourceArray[0]), height(sourceArray[1]){}

	/**
	 * RXgN^
	 * @param source ݒ肷鐡@
	 */
	explicit DimensionI(const DimensionF& source);

	//--------------------------------------------------------------------------
	// l̐ݒ
	//--------------------------------------------------------------------------
	/**
	 * l̐ݒ
	 * @param sourceWidth ̐ݒl
	 * @param sourceHeight ̐ݒl
	 */
	inline void set(int sourceWidth, int sourceHeight){
		width = sourceWidth;
		height = sourceHeight;
	}

	/**
	 * l̐ݒ
	 * @param sourceArray ݒlz
	 */
	inline void set(int sourceArray[2]){
		width = sourceArray[0];
		height = sourceArray[1];
	}

	/**
	 * l̐ݒ
	 * @param source ݒ肷鐡@
	 */
	void set(const DimensionF& source);

	//--------------------------------------------------------------------------
	// Z
	//--------------------------------------------------------------------------
	/**
	 * Z
	 * @param addDimension Z鐡@
	 * @return Zꂽ@
	 */
	inline DimensionI operator +(const DimensionI& addDimension) const{
		return DimensionI(width + addDimension.width,
			height + addDimension.height);
	}

	/**
	 * Z
	 * @param subDimension Z鐡@
	 * @return Zꂽ@
	 */
	inline DimensionI operator -(const DimensionI& subDimension) const{
		return DimensionI(width - subDimension.width,
			height - subDimension.height);
	}

	/**
	 * Z
	 * @param mulDimension Z鐡@
	 * @return Zꂽ@
	 */
	inline DimensionI operator *(const DimensionI& mulDimension) const{
		return DimensionI(width * mulDimension.width,
			height * mulDimension.height);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return Zꂽ@
	 */
	inline DimensionI operator *(float mulValue) const{
		return DimensionI((int)(width * mulValue), (int)(height * mulValue));
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @param mulDimension Z鐡@
	 * @return Zꂽ@
	 */
	inline friend DimensionI operator *(
		float mulValue, const DimensionI& mulDimension){
		return DimensionI((int)(mulDimension.width * mulValue),
			(int)(mulDimension.height * mulValue));
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return Zꂽ@
	 */
	inline DimensionI operator *(int mulValue) const{
		return DimensionI(width * mulValue, height * mulValue);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @param mulDimension Z鐡@
	 * @return Zꂽ@
	 */
	inline friend DimensionI operator *(
		int mulValue, const DimensionI& mulDimension){
		return DimensionI(mulDimension.width * mulValue,
			mulDimension.height * mulValue);
	}

	/**
	 * +Zq
	 * @return @̃Rs[
	 */
	inline DimensionI operator +() const{ return *this; }

	/**
	 * -Zq
	 * @return l̕]@
	 */
	inline DimensionI operator -() const{ return DimensionI(-width, -height); }

	//--------------------------------------------------------------------------
	// Z
	//--------------------------------------------------------------------------
	/**
	 * Z
	 * @param addDimension Z鐡@
	 * @return Zꂽ@
	 */
	inline DimensionI& operator +=(const DimensionI& addDimension){
		width += addDimension.width;
		height += addDimension.height;
		return (*this);
	}

	/**
	 * Z
	 * @param subDimension Z鐡@
	 * @return Zꂽ@
	 */
	inline DimensionI& operator -=(const DimensionI& subDimension){
		width -= subDimension.width;
		height -= subDimension.height;
		return (*this);
	}

	/**
	 * Z
	 * @param mulDimension Z鐡@
	 * @return Zꂽ@
	 */
	inline DimensionI& operator *=(const DimensionI& mulDimension){
		width *= mulDimension.width;
		height *= mulDimension.height;
		return (*this);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return Zꂽ@
	 */
	inline DimensionI& operator *=(float mulValue){
		width = (int)(width * mulValue);
		height = (int)(height * mulValue);
		return (*this);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return Zꂽ@
	 */
	inline DimensionI& operator *=(int mulValue){
		width *= mulValue;
		height *= mulValue;
		return (*this);
	}

	//--------------------------------------------------------------------------
	// _Z
	//--------------------------------------------------------------------------
	/**
	 * lǂ
	 * @param target r鐡@
	 * @return lłtrueԂ
	 */
	inline bool operator ==(const DimensionI& target) const{
		return ((width == target.width) && (height == target.height));
	}

	/**
	 * lłȂǂ
	 * @param target r鐡@
	 * @return lłȂtrueԂ
	 */
	inline bool operator !=(const DimensionI& target) const{
		return ((width != target.width) || (height != target.height));
	}

	//--------------------------------------------------------------------------
	// ̑
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return @̕\L
	 */
	inline String toString() const{
		String returnString;
		returnString.format("( %d, %d )", width, height);
		return returnString;
	}

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of DIMENSION_I_H_
//------------------------------------------------------------------------------
