//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * @wb_
 * @author Junpee
 */

#ifndef DIMENSION_F_H_
#define DIMENSION_F_H_

namespace Lamp{

class DimensionI;

//------------------------------------------------------------------------------
/**
 * @
 *
 * ̃NX͌pȂŉB
 */
class DimensionF{
public:
	//--------------------------------------------------------------------------
	// oϐ
	//--------------------------------------------------------------------------
	/// oϐ
	union{
		/// evf
		struct{
			/// 
			float width;
			/// 
			float height;
		};

		/// z
		float array[2];
	};

	//--------------------------------------------------------------------------
	// 萔
	//--------------------------------------------------------------------------
	/// [@
	static const DimensionF zero;

	/// Pʐ@
	static const DimensionF unit;

	//--------------------------------------------------------------------------
	// RXgN^
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 *
	 * ̃RXgN^͏l̐ݒsȂߒl͕słB
	 */
	DimensionF(){}

	/**
	 * RXgN^
	 * @param sourceWidth ̏l
	 * @param sourceHeight ̏l
	 */
	DimensionF(float sourceWidth, float sourceHeight) :
		width(sourceWidth), height(sourceHeight){}

	/**
	 * RXgN^
	 * @param sourceArray lz
	 */
	explicit DimensionF(float sourceArray[2]) :
		width(sourceArray[0]), height(sourceArray[1]){}

	/**
	 * RXgN^
	 * @param source ݒ肷鐡@
	 */
	explicit DimensionF(const DimensionI& source);

	//--------------------------------------------------------------------------
	// l̐ݒ
	//--------------------------------------------------------------------------
	/**
	 * l̐ݒ
	 * @param sourceWidth ̐ݒl
	 * @param sourceHeight ̐ݒl
	 */
	inline void set(float sourceWidth, float sourceHeight){
		width = sourceWidth;
		height = sourceHeight;
	}

	/**
	 * l̐ݒ
	 * @param sourceArray ݒlz
	 */
	inline void set(float sourceArray[2]){
		width = sourceArray[0];
		height = sourceArray[1];
	}

	/**
	 * l̐ݒ
	 * @param source ݒ肷鐡@
	 */
	void set(const DimensionI& source);

	//--------------------------------------------------------------------------
	// Z
	//--------------------------------------------------------------------------
	/**
	 * Z
	 * @param addDimension Z鐡@
	 * @return Zꂽ@
	 */
	inline DimensionF operator +(const DimensionF& addDimension) const{
		return DimensionF(width + addDimension.width,
			height + addDimension.height);
	}

	/**
	 * Z
	 * @param subDimension Z鐡@
	 * @return Zꂽ@
	 */
	inline DimensionF operator -(const DimensionF& subDimension) const{
		return DimensionF(width - subDimension.width,
			height - subDimension.height);
	}

	/**
	 * Z
	 * @param mulDimension Z鐡@
	 * @return Zꂽ@
	 */
	inline DimensionF operator *(const DimensionF& mulDimension) const{
		return DimensionF(width * mulDimension.width,
			height * mulDimension.height);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return Zꂽ@
	 */
	inline DimensionF operator *(float mulValue) const{
		return DimensionF(width * mulValue, height * mulValue);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @param mulDimension Z鐡@
	 * @return Zꂽ@
	 */
	inline friend DimensionF operator *(
		float mulValue, const DimensionF& mulDimension){
		return DimensionF(mulDimension.width * mulValue,
			mulDimension.height * mulValue);
	}

	/**
	 * +Zq
	 * @return xNg̃Rs[
	 */
	inline DimensionF operator +() const{ return *this; }

	/**
	 * -Zq
	 * @return l̕]xNg
	 */
	inline DimensionF operator -() const{ return DimensionF(-width, -height); }

	//--------------------------------------------------------------------------
	// Z
	//--------------------------------------------------------------------------
	/**
	 * Z
	 * @param addDimension Z鐡@
	 * @return Zꂽ@
	 */
	inline DimensionF& operator +=(const DimensionF& addDimension){
		width += addDimension.width;
		height += addDimension.height;
		return (*this);
	}

	/**
	 * Z
	 * @param subDimension Z鐡@
	 * @return Zꂽ@
	 */
	inline DimensionF& operator -=(const DimensionF& subDimension){
		width -= subDimension.width;
		height -= subDimension.height;
		return (*this);
	}

	/**
	 * Z
	 * @param mulDimension Z鐡@
	 * @return Zꂽ@
	 */
	inline DimensionF& operator *=(const DimensionF& mulDimension){
		width *= mulDimension.width;
		height *= mulDimension.height;
		return (*this);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return Zꂽ@
	 */
	inline DimensionF& operator *=(float mulValue){
		width *= mulValue;
		height *= mulValue;
		return (*this);
	}

	//--------------------------------------------------------------------------
	// _Z
	//--------------------------------------------------------------------------
	/**
	 * lǂ
	 * @param target r鐡@
	 * @return lłtrueԂ
	 */
	inline bool operator ==(const DimensionF& target) const{
		return ((width == target.width) && (height == target.height));
	}

	/**
	 * lǂ
	 * @param target r鐡@
	 * @param epsilon 덷
	 * @return 덷͈͓̔œlłtrueԂ
	 */
	inline bool epsilonEquals(const DimensionF& target, float epsilon) const{
		Assert(epsilon >= 0.f);
		return (
			(Math::abs(width - target.width) <= epsilon) &&
			(Math::abs(height - target.height) <= epsilon));
	}

	/**
	 * lłȂǂ
	 * @param target r鐡@
	 * @return lłȂtrueԂ
	 */
	inline bool operator !=(const DimensionF& target) const{
		return ((width != target.width) || (height != target.height));
	}

	/**
	 * lłȂǂ
	 * @param target r鐡@
	 * @param epsilon 덷
	 * @return 덷͈͓̔œłȂlłtrueԂ
	 */
	inline bool notEpsilonEquals(
		const DimensionF& target, float epsilon) const{
		Assert(epsilon >= 0.f);
		return (
			(Math::abs(width - target.width) > epsilon) ||
			(Math::abs(height - target.height) > epsilon));
	}

	//--------------------------------------------------------------------------
	// ̑
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return @̕\L
	 */
	inline String toString() const{
		String returnString;
		returnString.format("( %.8f, %.8f )", width, height);
		return returnString;
	}

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of DIMENSION_F_H_
//------------------------------------------------------------------------------
