//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * lvfLN^J[wb_
 * @author Junpee
 */

#ifndef COLOR_4C_H_
#define COLOR_4C_H_

#include <Core/System/Math.h>

namespace Lamp{

class Color3c;
class Color3f;
class Color4f;

//------------------------------------------------------------------------------
/**
 * lvfLN^J[
 *
 * ̃NX͌pȂŉB
 */
class Color4c{
public:
	//--------------------------------------------------------------------------
	// oϐ
	//--------------------------------------------------------------------------
	/// oϐ
	union{
		/// evf
		struct{
			/// 
			u_char r;
			/// 
			u_char g;
			/// 
			u_char b;
			/// At@
			u_char a;
		};

		/// z
		u_char array[4];
	};

	//--------------------------------------------------------------------------
	// 萔
	//--------------------------------------------------------------------------
	/// 
	static const Color4c white;

	/// DF
	static const Color4c gray;

	/// 
	static const Color4c black;

	/// 
	static const Color4c red;

	/// 
	static const Color4c green;

	/// 
	static const Color4c blue;

	/// 
	static const Color4c yellow;

	/// 
	static const Color4c cyan;

	/// Ԏ
	static const Color4c magenta;

	//--------------------------------------------------------------------------
	// RXgN^
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 *
	 * ̃RXgN^͏l̐ݒsȂߒl͕słB
	 */
	Color4c(){}

	/**
	 * RXgN^
	 * @param sourceR Ԃ̏l
	 * @param sourceG ΂̏l
	 * @param sourceB ̏l
	 * @param sourceA At@̏l
	 */
	inline Color4c(u_char sourceR, u_char sourceG, u_char sourceB,
		u_char sourceA = 255) :
		r(sourceR), g(sourceG), b(sourceB), a(sourceA){
	}

	/**
	 * RXgN^
	 * @param source ݒ肷F
	 */
	explicit Color4c(const Color3c& source);

	/**
	 * RXgN^
	 * @param source ݒ肷F
	 */
	explicit Color4c(const Color3f& source);

	/**
	 * RXgN^
	 * @param source ݒ肷F
	 */
	explicit Color4c(const Color4f& source);

	//--------------------------------------------------------------------------
	// l̐ݒ
	//--------------------------------------------------------------------------
	/**
	 * l̐ݒ
	 * @param sourceR Ԃ̐ݒl
	 * @param sourceG ΂̐ݒl
	 * @param sourceB ̐ݒl
	 * @param sourceA At@̐ݒl
	 */
	inline void set(u_char sourceR, u_char sourceG, u_char sourceB,
		u_char sourceA = 255){
		r = sourceR;
		g = sourceG;
		b = sourceB;
		a = sourceA;
	}

	/**
	 * OvfLN^J[̐ݒ
	 * @param source ݒ肷F
	 */
	void set(const Color3c& source);

	/**
	 * OvfJ[̐ݒ
	 * @param source ݒ肷F
	 */
	void set(const Color3f& source);

	/**
	 * lvfJ[̐ݒ
	 * @param source ݒ肷F
	 */
	void set(const Color4f& source);

	/**
	 * ARGBJ[̐ݒ
	 * @param source
	 */
	void setARGB(u_int source){
		r = (u_char)((source & 0xff0000) >> 16);
		g = (u_char)((source & 0xff00) >> 8);
		b = (u_char)(source & 0xff);
		a = (u_char)((source & 0xff000000) >> 24);
	}

	//--------------------------------------------------------------------------
	// l̎擾
	//--------------------------------------------------------------------------
	/**
	 * ARGBJ[̎擾
	 * @return ARGBJ[
	 */
	u_int getARGB() const{
		return (((u_int)a << 24) | ((u_int)r << 16) |
			((u_int)g << 8) | ((u_int)b));
	}

	//--------------------------------------------------------------------------
	// Z
	//--------------------------------------------------------------------------
	/**
	 * Z
	 * @param addColor ZF
	 * @return ZꂽF
	 */
	inline Color4c operator +(const Color4c& addColor) const{
		int addR = (int)r + addColor.r;
		if(addR > 255){ addR = 255; }
		int addG = (int)g + addColor.g;
		if(addG > 255){ addG = 255; }
		int addB = (int)b + addColor.b;
		if(addB > 255){ addB = 255; }
		int addA = (int)a + addColor.a;
		if(addA > 255){ addA = 255; }
		return Color4c(addR, addG, addB, addA);
	}

	/**
	 * Z
	 * @param subColor ZF
	 * @return ZꂽF
	 */
	inline Color4c operator -(const Color4c& subColor) const{
		int subR = (int)r - subColor.r;
		if(subR < 0){ subR = 0; }
		int subG = (int)g - subColor.g;
		if(subG < 0){ subG = 0; }
		int subB = (int)b - subColor.b;
		if(subB < 0){ subB = 0; }
		int subA = (int)a - subColor.a;
		if(subA < 0){ subA = 0; }
		return Color4c(subR, subG, subB, subA);
	}

	/**
	 * Z
	 * @param mulColor ZF
	 * @return ZꂽF
	 */
	inline Color4c operator *(const Color4c& mulColor) const{
		int mulR = ((int)r * mulColor.r) / 255;
		int mulG = ((int)g * mulColor.g) / 255;
		int mulB = ((int)b * mulColor.b) / 255;
		int mulA = ((int)a * mulColor.a) / 255;
		return Color4c(mulR, mulG, mulB, mulA);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return ZꂽF
	 */
	inline Color4c operator *(float mulValue) const{
		int mulR = (int)(r * mulValue);
		if(mulR > 255){
			mulR = 255;
		}else if(mulR < 0){
			mulR = 0;
		}
		int mulG = (int)(g * mulValue);
		if(mulG > 255){
			mulG = 255;
		} else if(mulG < 0){
			mulG = 0;
		}
		int mulB = (int)(b * mulValue);
		if(mulB > 255){
			mulB = 255;
		}else if(mulB < 0){
			mulB = 0;
		}
		int mulA = (int)(a * mulValue);
		if(mulA > 255){
			mulA = 255;
		}else if(mulA < 0){
			mulA = 0;
		}
		return Color4c(mulR, mulG, mulB, mulA);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @param mulColor ZF
	 * @return ZꂽF
	 */
	inline friend Color4c operator *(float mulValue, const Color4c& mulColor){
		int mulR = (int)(mulColor.r * mulValue);
		if(mulR > 255){
			mulR = 255;
		}else if(mulR < 0){
			mulR = 0;
		}
		int mulG = (int)(mulColor.g * mulValue);
		if(mulG > 255){
			mulG = 255;
		} else if(mulG < 0){
			mulG = 0;
		}
		int mulB = (int)(mulColor.b * mulValue);
		if(mulB > 255){
			mulB = 255;
		}else if(mulB < 0){
			mulB = 0;
		}
		int mulA = (int)(mulColor.a * mulValue);
		if(mulA > 255){
			mulA = 255;
		}else if(mulA < 0){
			mulA = 0;
		}
		return Color4c(mulR, mulG, mulB, mulA);
	}

	//--------------------------------------------------------------------------
	// Z
	//--------------------------------------------------------------------------
	/**
	 * Z
	 * @param addColor ZF
	 * @return ZꂽF
	 */
	inline Color4c& operator +=(const Color4c& addColor){
		int addR = (int)r + addColor.r;
		if(addR > 255){ addR = 255; }
		int addG = (int)g + addColor.g;
		if(addG > 255){ addG = 255; }
		int addB = (int)b + addColor.b;
		if(addB > 255){ addB = 255; }
		int addA = (int)a + addColor.a;
		if(addA > 255){ addA = 255; }
		set(addR, addG, addB, addA);
		return (*this);
	}

	/**
	 * Z
	 * @param subColor ZF
	 * @return ZꂽF
	 */
	inline Color4c& operator -=(const Color4c& subColor){
		int subR = (int)r - subColor.r;
		if(subR < 0){ subR = 0; }
		int subG = (int)g - subColor.g;
		if(subG < 0){ subG = 0; }
		int subB = (int)b - subColor.b;
		if(subB < 0){ subB = 0; }
		int subA = (int)a - subColor.a;
		if(subA < 0){ subA = 0; }
		set(subR, subG, subB, subA);
		return (*this);
	}

	/**
	 * Z
	 * @param mulColor ZF
	 * @return ZꂽF
	 */
	inline Color4c& operator *=(const Color4c& mulColor){
		int mulR = ((int)r * mulColor.r) / 255;
		int mulG = ((int)g * mulColor.g) / 255;
		int mulB = ((int)b * mulColor.b) / 255;
		int mulA = ((int)a * mulColor.a) / 255;
		set(mulR, mulG, mulB, mulA);
		return (*this);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return ZꂽF
	 */
	inline Color4c& operator *=(float mulValue){
		int mulR = (int)(r * mulValue);
		if(mulR > 255){
			mulR = 255;
		}else if(mulR < 0){
			mulR = 0;
		}
		int mulG = (int)(g * mulValue);
		if(mulG > 255){
			mulG = 255;
		} else if(mulG < 0){
			mulG = 0;
		}
		int mulB = (int)(b * mulValue);
		if(mulB > 255){
			mulB = 255;
		}else if(mulB < 0){
			mulB = 0;
		}
		int mulA = (int)(a * mulValue);
		if(mulA > 255){
			mulA = 255;
		}else if(mulA < 0){
			mulA = 0;
		}
		set(mulR, mulG, mulB, mulA);
		return (*this);
	}

	//--------------------------------------------------------------------------
	// FZ
	//--------------------------------------------------------------------------
	/**
	 * ΐF
	 *
	 * At@l͕ω܂B
	 * @return ]ꂽF
	 */
	inline Color4c& negative(){
		set(255 - r, 255 - g, 255 - b, a);
		return (*this);
	}

	/**
	 * F̐`
	 * @param source JnF
	 * @param target ΏېF
	 * @param alpha uhW
	 * @return `ԂꂽF
	 */
	inline static Color4c lerp(
		const Color4c& source, const Color4c& target, float alpha){
		float beta = 1.f - alpha;
		Color4c result;
		result.r = (u_char)(source.r * beta + target.r * alpha);
		result.g = (u_char)(source.g * beta + target.g * alpha);
		result.b = (u_char)(source.b * beta + target.b * alpha);
		result.a = (u_char)(source.a * beta + target.a * alpha);
		return result;
	}

	//--------------------------------------------------------------------------
	// _Z
	//--------------------------------------------------------------------------
	/**
	 * lǂ
	 * @param target rJ[
	 * @return lłtrueԂ
	 */
	inline bool operator ==(const Color4c& target) const{
		return ((r == target.r) && (g == target.g) &&
			(b == target.b) && (a == target.a));
	}

	/**
	 * lłȂǂ
	 * @param target rJ[
	 * @return lłȂtrueԂ
	 */
	inline bool operator !=(const Color4c& target) const{
		return ((r != target.r) || (g != target.g) ||
			(b != target.b) || (a != target.a));
	}

	//--------------------------------------------------------------------------
	// ̑
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return J[̕\L
	 */
	inline String toString() const{
		String returnString;
		returnString.format("( %d, %d, %d, %d )", r, g, b, a);
		return returnString;
	}

	//--------------------------------------------------------------------------
private:

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of COLOR_4C_H_
//------------------------------------------------------------------------------
