//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OvfLN^J[wb_
 * @author Junpee
 */

#ifndef COLOR_3C_H_
#define COLOR_3C_H_

#include <Core/System/Math.h>

namespace Lamp{

class Color4c;
class Color3f;
class Color4f;

//------------------------------------------------------------------------------
/**
 * OvfLN^J[
 *
 * ̃NX͌pȂŉB
 */
class Color3c{
public:
	//--------------------------------------------------------------------------
	// oϐ
	//--------------------------------------------------------------------------
	/// oϐ
	union{
		/// evf
		struct{
			/// 
			u_char r;
			/// 
			u_char g;
			/// 
			u_char b;
		};

		/// z
		u_char array[3];
	};

	//--------------------------------------------------------------------------
	// 萔
	//--------------------------------------------------------------------------
	/// 
	static const Color3c white;

	/// DF
	static const Color3c gray;

	/// 
	static const Color3c black;

	/// 
	static const Color3c red;

	/// 
	static const Color3c green;

	/// 
	static const Color3c blue;

	/// 
	static const Color3c yellow;

	/// 
	static const Color3c cyan;

	/// Ԏ
	static const Color3c magenta;

	//--------------------------------------------------------------------------
	// RXgN^
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 *
	 * ̃RXgN^͏l̐ݒsȂߒl͕słB
	 */
	Color3c(){}

	/**
	 * RXgN^
	 * @param sourceR Ԃ̏l
	 * @param sourceG ΂̏l
	 * @param sourceB ̏l
	 */
	inline Color3c(u_char sourceR, u_char sourceG, u_char sourceB) :
		r(sourceR), g(sourceG), b(sourceB){
	}

	/**
	 * RXgN^
	 * @param source ݒ肷F
	 */
	explicit Color3c(const Color4c& source);

	/**
	 * RXgN^
	 * @param source ݒ肷F
	 */
	explicit Color3c(const Color3f& source);

	/**
	 * RXgN^
	 * @param source ݒ肷F
	 */
	explicit Color3c(const Color4f& source);

	//--------------------------------------------------------------------------
	// l̐ݒ
	//--------------------------------------------------------------------------
	/**
	 * l̐ݒ
	 * @param sourceR Ԃ̐ݒl
	 * @param sourceG ΂̐ݒl
	 * @param sourceB ̐ݒl
	 */
	inline void set(u_char sourceR, u_char sourceG, u_char sourceB){
		r = sourceR;
		g = sourceG;
		b = sourceB;
	}

	/**
	 * lvfLN^J[̐ݒ
	 * @param source ݒ肷F
	 */
	void set(const Color4c& source);

	/**
	 * OvfJ[̐ݒ
	 * @param source ݒ肷F
	 */
	void set(const Color3f& source);

	/**
	 * lvfJ[̐ݒ
	 * @param source ݒ肷F
	 */
	void set(const Color4f& source);

	/**
	 * ARGBJ[̐ݒ
	 * @param source
	 */
	void setARGB(u_int source){
		r = (u_char)((source & 0xff0000) >> 16);
		g = (u_char)((source & 0xff00) >> 8);
		b = (u_char)(source & 0xff);
	}

	//--------------------------------------------------------------------------
	// l̎擾
	//--------------------------------------------------------------------------
	/**
	 * ARGBJ[̎擾
	 * @return ARGBJ[
	 */
	u_int getARGB() const{
		return (0xff000000 | ((u_int)r << 16) | ((u_int)g << 8) | ((u_int)b));
	}

	//--------------------------------------------------------------------------
	// Z
	//--------------------------------------------------------------------------
	/**
	 * Z
	 * @param addColor ZF
	 * @return ZꂽF
	 */
	inline Color3c operator +(const Color3c& addColor) const{
		int addR = (int)r + addColor.r;
		if(addR > 255){ addR = 255; }
		int addG = (int)g + addColor.g;
		if(addG > 255){ addG = 255; }
		int addB = (int)b + addColor.b;
		if(addB > 255){ addB = 255; }
		return Color3c(addR, addG, addB);
	}

	/**
	 * Z
	 * @param subColor ZF
	 * @return ZꂽF
	 */
	inline Color3c operator -(const Color3c& subColor) const{
		int subR = (int)r - subColor.r;
		if(subR < 0){ subR = 0; }
		int subG = (int)g - subColor.g;
		if(subG < 0){ subG = 0; }
		int subB = (int)b - subColor.b;
		if(subB < 0){ subB = 0; }
		return Color3c(subR, subG, subB);
	}

	/**
	 * Z
	 * @param mulColor ZF
	 * @return ZꂽF
	 */
	inline Color3c operator *(const Color3c& mulColor) const{
		int mulR = ((int)r * mulColor.r) / 255;
		int mulG = ((int)g * mulColor.g) / 255;
		int mulB = ((int)b * mulColor.b) / 255;
		return Color3c(mulR, mulG, mulB);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return ZꂽF
	 */
	inline Color3c operator *(float mulValue) const{
		int mulR = (int)(r * mulValue);
		if(mulR > 255){
			mulR = 255;
		}else if(mulR < 0){
			mulR = 0;
		}
		int mulG = (int)(g * mulValue);
		if(mulG > 255){
			mulG = 255;
		} else if(mulG < 0){
			mulG = 0;
		}
		int mulB = (int)(b * mulValue);
		if(mulB > 255){
			mulB = 255;
		}else if(mulB < 0){
			mulB = 0;
		}
		return Color3c(mulR, mulG, mulB);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @param mulColor ZF
	 * @return ZꂽF
	 */
	inline friend Color3c operator *(float mulValue, const Color3c& mulColor){
		int mulR = (int)(mulColor.r * mulValue);
		if(mulR > 255){
			mulR = 255;
		}else if(mulR < 0){
			mulR = 0;
		}
		int mulG = (int)(mulColor.g * mulValue);
		if(mulG > 255){
			mulG = 255;
		} else if(mulG < 0){
			mulG = 0;
		}
		int mulB = (int)(mulColor.b * mulValue);
		if(mulB > 255){
			mulB = 255;
		}else if(mulB < 0){
			mulB = 0;
		}
		return Color3c(mulR, mulG, mulB);
	}

	//--------------------------------------------------------------------------
	// Z
	//--------------------------------------------------------------------------
	/**
	 * Z
	 * @param addColor ZF
	 * @return ZꂽF
	 */
	inline Color3c& operator +=(const Color3c& addColor){
		int addR = (int)r + addColor.r;
		if(addR > 255){ addR = 255; }
		int addG = (int)g + addColor.g;
		if(addG > 255){ addG = 255; }
		int addB = (int)b + addColor.b;
		if(addB > 255){ addB = 255; }
		set(addR, addG, addB);
		return (*this);
	}

	/**
	 * Z
	 * @param subColor ZF
	 * @return ZꂽF
	 */
	inline Color3c& operator -=(const Color3c& subColor){
		int subR = (int)r - subColor.r;
		if(subR < 0){ subR = 0; }
		int subG = (int)g - subColor.g;
		if(subG < 0){ subG = 0; }
		int subB = (int)b - subColor.b;
		if(subB < 0){ subB = 0; }
		set(subR, subG, subB);
		return (*this);
	}

	/**
	 * Z
	 * @param mulColor ZF
	 * @return ZꂽF
	 */
	inline Color3c& operator *=(const Color3c& mulColor){
		int mulR = ((int)r * mulColor.r) / 255;
		int mulG = ((int)g * mulColor.g) / 255;
		int mulB = ((int)b * mulColor.b) / 255;
		set(mulR, mulG, mulB);
		return (*this);
	}

	/**
	 * Z
	 * @param mulValue Zl
	 * @return ZꂽF
	 */
	inline Color3c& operator *=(float mulValue){
		int mulR = (int)(r * mulValue);
		if(mulR > 255){
			mulR = 255;
		}else if(mulR < 0){
			mulR = 0;
		}
		int mulG = (int)(g * mulValue);
		if(mulG > 255){
			mulG = 255;
		} else if(mulG < 0){
			mulG = 0;
		}
		int mulB = (int)(b * mulValue);
		if(mulB > 255){
			mulB = 255;
		}else if(mulB < 0){
			mulB = 0;
		}
		set(mulR, mulG, mulB);
		return (*this);
	}

	//--------------------------------------------------------------------------
	// FZ
	//--------------------------------------------------------------------------
	/**
	 * ΐF
	 * @return ]ꂽF
	 */
	inline Color3c& negative(){
		set(255 - r, 255 - g, 255 - b);
		return (*this);
	}

	/**
	 * F̐`
	 * @param source JnF
	 * @param target ΏېF
	 * @param alpha uhW
	 * @return `ԂꂽF
	 */
	inline static Color3c lerp(
		const Color3c& source, const Color3c& target, float alpha){
		float beta = 1.f - alpha;
		Color3c result;
		result.r = (u_char)(source.r * beta + target.r * alpha);
		result.g = (u_char)(source.g * beta + target.g * alpha);
		result.b = (u_char)(source.b * beta + target.b * alpha);
		return result;
	}

	//--------------------------------------------------------------------------
	// _Z
	//--------------------------------------------------------------------------
	/**
	 * lǂ
	 * @param target rJ[
	 * @return lłtrueԂ
	 */
	inline bool operator ==(const Color3c& target) const{
		return ((r == target.r) && (g == target.g) && (b == target.b));
	}

	/**
	 * lłȂǂ
	 * @param target rJ[
	 * @return lłȂtrueԂ
	 */
	inline bool operator !=(const Color3c& target) const{
		return ((r != target.r) || (g != target.g) || (b != target.b));
	}

	//--------------------------------------------------------------------------
	// ̑
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return xNg̕\L
	 */
	inline String toString() const{
		String returnString;
		returnString.format("( %d, %d, %d )", r, g, b);
		return returnString;
	}

	//--------------------------------------------------------------------------
private:

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of COLOR_3C_H_
//------------------------------------------------------------------------------
