//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * rbgZbgwb_
 * @author Junpee
 */

#ifndef BIT_SET_H_
#define BIT_SET_H_

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * rbgZbg
 *
 * ev[ǧ^u_char, u_short, u_intgpĂB
 * ̃NX͌pȂŉB
 */
template <typename Type>
class BitSet{
public:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	BitSet() : bits_(0){}

	/**
	 * RXgN^
	 * @param bits rbg
	 */
	BitSet(const Type& bits) : bits_(bits){}

	/**
	 * fXgN^
	 */
	~BitSet(){}

	//--------------------------------------------------------------------------
	/**
	 * ̎擾
	 * @return 
	 */
	int getLength() const{ return sizeof(Type) * 8; }

	/**
	 * NA
	 */
	void clear(){ bits_ = 0; }

	//--------------------------------------------------------------------------
	/**
	 * rbg̐ݒ
	 * @param bits rbg
	 */
	void setBits(Type bits){ bits_ = bits; }

	/**
	 * rbg̎擾
	 * @return rbg
	 */
	Type getBits() const{ return bits_; }

	//--------------------------------------------------------------------------
	// Srbgɑ΂鑀
	//--------------------------------------------------------------------------
	/**
	 * ␔
	 * @return rbgZbg
	 */
	const BitSet& not(){
		bits_ = ~bits_;
		return (*this);
	}

	/**
	 * SẴrbgONɂ
	 * @return rbgZbg
	 */
	const BitSet& onAllBits(){
		bits_ = 0;
		bits_ = ~bits_;
		return (*this);
	}

	/**
	 * SẴrbgOFFɂ
	 * @return rbgZbg
	 */
	const BitSet& offAllBits(){
		bits_ = 0;
		return (*this);
	}

	/**
	 * SẴrbgݒ肷
	 * @param flag trueȂrbgONɂ܂
	 * @return rbgZbg
	 */
	const BitSet& setAllBits(bool flag){
		if(flag){ onAllBits(); }
		else{ offAllBits(); }
		return (*this);
	}

	//--------------------------------------------------------------------------
	// rbgZbgɂrbg
	//--------------------------------------------------------------------------
	/**
	 * _
	 * @param bitSet _ςƂrbgZbg
	 * @return rbgZbg
	 */
	const BitSet& and(const BitSet& bitSet){
		bits_ &= bitSet.bits_;
		return (*this);
	}

	/**
	 * _a
	 * @param bitSet _aƂrbgZbg
	 * @return rbgZbg
	 */
	const BitSet& or(const BitSet& bitSet){
		bits_ |= bitSet.bits_;
		return (*this);
	}

	/**
	 * rI_a
	 * @param bitSet rI_aƂrbgZbg
	 * @return rbgZbg
	 */
	const BitSet& xor(const BitSet& bitSet){
		bits_ ^= bitSet.bits_;
		return (*this);
	}

	/**
	 * rbgONɂ
	 * @param bitSet ݒ肷rbgZbg
	 * @return rbgZbg
	 */
	const BitSet& onBit(const BitSet& bitSet){
		bits_ |= bitSet.bits_;
		return (*this);
	}

	/**
	 * rbgOFFɂ
	 * @param bitSet ݒ肷rbgZbg
	 * @return rbgZbg
	 */
	const BitSet& offBit(const BitSet& bitSet){
		bits_ &= (~bitSet.bits_);
		return (*this);
	}

	/**
	 * rbg̐ݒ
	 * @param bitSet rbgݒ肷rbgZbg
	 * @param flag trueȂrbgONɂ܂
	 * @return rbgZbg
	 */
	const BitSet& setBit(const BitSet& bitSet, bool flag){
		if(flag){ onBit(bitSet); }
		else{ offBit(bitSet); }
		return (*this);
	}

	/**
	 * rbg̎擾
	 * @param bitSet rbg擾rbgZbg
	 * @return rbgׂONȂtrue
	 */
	bool getBit(const BitSet& bitSet) const{
		return ((bits_ & bitSet.bits_) == bitSet.bits_);
	}

	//--------------------------------------------------------------------------
	// rbgɂrbg
	//--------------------------------------------------------------------------
	/**
	 * _
	 * @param bits _ςƂrbg
	 * @return rbgZbg
	 */
	const BitSet& and(Type bits){
		bits_ &= bits;
		return (*this);
	}

	/**
	 * _a
	 * @param bits _aƂrbg
	 * @return rbgZbg
	 */
	const BitSet& or(Type bits){
		bits_ |= bits;
		return (*this);
	}

	/**
	 * rI_a
	 * @param bits rI_aƂrbg
	 * @return rbgZbg
	 */
	const BitSet& xor(Type bits){
		bits_ ^= bits;
		return (*this);
	}

	/**
	 * rbgONɂ
	 * @param bits ݒ肷rbg
	 * @return rbgZbg
	 */
	const BitSet& onBit(Type bits){
		bits_ |= bits;
		return (*this);
	}

	/**
	 * rbgOFFɂ
	 * @param bits ݒ肷rbg
	 * @return rbgZbg
	 */
	const BitSet& offBit(Type bits){
		bits_ &= (~bits);
		return (*this);
	}

	/**
	 * rbg̐ݒ
	 * @param bits rbgݒ肷rbg
	 * @param flag trueȂrbgONɂ܂
	 * @return rbgZbg
	 */
	const BitSet& setBit(Type bits, bool flag){
		if(flag){ onBit(bits); }
		else{ offBit(bits); }
		return (*this);
	}

	/**
	 * rbg̎擾
	 * @param bits rbg擾rbg
	 * @return rbgׂONȂtrue
	 */
	bool getBit(Type bits) const{
		return ((bits_ & bits) == bits);
	}

	//--------------------------------------------------------------------------
	// CfbNXɂrbg
	//--------------------------------------------------------------------------
	/**
	 * CfbNXrbgONɂ
	 * @param index rbg̃CfbNX
	 */
	const BitSet& onIndexedBit(int index){
		Assert((index >= 0) && (index < getLength()));
		bits_ |= (0x1 << index);
		return (*this);
	}

	/**
	 * CfbNXrbgOFFɂ
	 * @param index rbg̃CfbNX
	 */
	const BitSet& offIndexedBit(int index){
		Assert((index >= 0) && (index < getLength()));
		bits_ &= (~(0x1 << index));
		return (*this);
	}

	/**
	 * CfbNXrbg̐ݒ
	 * @param index rbg̃CfbNX
	 * @param flag trueȂrbgONɂ܂
	 */
	const BitSet& setIndexedBit(int index, bool flag){
		if(flag){ onIndexedBit(index); }
		else{ offIndexedBit(index); }
		return (*this);
	}

	/**
	 * CfbNXrbg̎擾
	 * @param index rbg̃CfbNX
	 * @return CfbNX̃rbgĂtrue
	 */
	bool getIndexedBit(int index) const{
		Assert((index >= 0) && (index < getLength()));
		return ((bits_ & (0x1 << index)) != 0);
	}

	//--------------------------------------------------------------------------
	/**
	 * ւ̕ϊ
	 * @return 
	 */
	String toString() const{
		String result;
		for(int i = getLength() - 1; i >= 0; i--){
			if(getIndexedBit(i)){ result += "1"; }
			else{ result += "0"; }
		}
		return result;
	}

private:
	//--------------------------------------------------------------------------
	// rbg
	Type bits_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of BIT_SET_H_
//------------------------------------------------------------------------------

