//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Owb_
 * @author Junpee
 */

#ifndef AXIS_3_H_
#define AXIS_3_H_

#include <Core/Primitive/Matrix34.h>
#include <Core/Primitive/Vector3.h>
#include <Core/Primitive/Quaternion.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * O
 */
class Axis3{
public:
	/**
	 * RXgN^
	 */
	Axis3() : matrix_(Matrix34::unit), quaternion_(Quaternion::identity),
		scale_(Vector3::unitScale), euler_(Vector3::zero),
		translation_(Vector3::zero),
		validEuler_(true), validQuaternion_(true), isChanged_(true){
		// isChanged_(true) ̌vZ͋v
	}

	/**
	 * Rs[RXgN^
	 * @param source Rs[
	 */
	Axis3(const Axis3& source) : matrix_(source.matrix_),
		quaternion_(source.quaternion_), scale_(source.scale_),
		euler_(source.euler_), translation_(source.translation_),
		validEuler_(source.validEuler_),
		validQuaternion_(source.validQuaternion_), isChanged_(true){
		// isChanged_(true) ̌vZ͋v
	}

	/**
	 * fXgN^
	 */
	virtual ~Axis3(){}

	//--------------------------------------------------------------------------
	/**
	 * XP[̐ݒ
	 * @param scale XP[
	 */
	virtual void setScale(const Vector3& scale){
		if(scale_ == scale){ return; }
		scale_ = scale;
		isChanged_ = true;
	}

	/**
	 * XP[̎擾
	 * @return XP[
	 */
	virtual const Vector3& getScale() const{ return scale_; }

	/**
	 * XP[gpĂ邩
	 * @return XP[gpĂȂtrue
	 */
	virtual bool isScaled() const{ return (scale_ != Vector3::unitScale); }

	//--------------------------------------------------------------------------
	/**
	 * XYZ]̐ݒ
	 * @param rotation XYZ]
	 */
	virtual void setRotationXYZ(const Vector3& rotation){
		if(validEuler_ && (euler_ == rotation)){ return; }
		euler_ = rotation;
		validEuler_ = true;
		validQuaternion_ = false;
		isChanged_ = true;
	}

	/**
	 * XYZ]̎擾
	 * @return XYZ]
	 */
	virtual const Vector3& getRotationXYZ(){
		if(!validEuler_){
			quaternion_.getRotationXYZ(&euler_);
			validEuler_ = true;
		}
		return euler_;
	}

	//--------------------------------------------------------------------------
	/**
	 * l]̐ݒ
	 * @param rotation l]
	 */
	virtual void setRotationQuaternion(const Quaternion& rotation){
		if(validQuaternion_ && (quaternion_ == rotation)){ return; }
		quaternion_ = rotation;
		validEuler_ = false;
		validQuaternion_ = true;
		isChanged_ = true;
	}

	/**
	 * l]̎擾
	 * @return l]
	 */
	virtual const Quaternion& getRotationQuaternion(){
		if(!validQuaternion_){
			quaternion_.setRotationXYZ(euler_);
			validQuaternion_ = true;
		}
		return quaternion_;
	}

	//--------------------------------------------------------------------------
	/**
	 * ړ̐ݒ
	 * @param translation ړ
	 */
	virtual void setTranslation(const Vector3& translation){
		if(translation_ == translation){ return; }
		translation_ = translation;
		isChanged_ = true;
	}

	/**
	 * ړ̎擾
	 * @return ړ
	 */
	virtual const Vector3& getTranslation() const{ return translation_; }

	//--------------------------------------------------------------------------
	/**
	 * s̍\z
	 * @return č\zȂtrue
	 */
	virtual bool buildMatrix(){
		if(isChanged_){
			if(validQuaternion_){
				matrix_.setTransformationQuaternion(
					scale_, quaternion_, translation_);
			}else{
				Assert(validEuler_);
				matrix_.setTransformationXYZ(scale_, euler_, translation_);
			}
			isChanged_ = false;
			return true;
		}
		return false;
	}

	/**
	 * s̎擾
	 * @return s
	 */
	virtual const Matrix34& getMatrix() const{
		Assert(!isChanged_);
		return matrix_;
	}

	//--------------------------------------------------------------------------
	/**
	 * ύXĂ邩
	 * @return ύXĂtrue
	 */
	virtual bool isChanged() const{ return isChanged_; }

	//--------------------------------------------------------------------------
protected:
	/// s
	Matrix34 matrix_;
	/// l]
	Quaternion quaternion_;
	/// XP[
	Vector3 scale_;
	/// IC[]
	Vector3 euler_;
	/// ړ
	Vector3 translation_;
	/// IC[]L
	bool validEuler_;
	/// l]L
	bool validQuaternion_;
	/// ύXtO
	bool isChanged_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of AXIS_3_H_
//------------------------------------------------------------------------------
