//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * C^wb_
 * @author Junpee
 */

#ifndef WRITER_H_
#define WRITER_H_

#include <Core/InputOutput/OutputStream.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * C^
 *
 * f[^õC^[tF[X
 */
class Writer{
public:
	/**
	 * oCgf[^̏o
	 * @param data ooCgf[^
	 * @param size oTCY
	 */
	void writeBytes(const void* data, int size){
		Assert(stream_ != NULL);
		stream_->writeBytes(data, size);
	}

	/**
	 * TCY̎擾
	 * @return 񂾃oCg
	 */
	int getSize(){
		Assert(stream_ != NULL);
		return stream_->getSize();
	}

	/**
	 * XLbv
	 *
	 * w肳ꂽoCgA0o܂B
	 * @param size 0ooCg
	 */
	void skip(int size){
		Assert(stream_ != NULL);
		stream_->skip(size);
	}

	/**
	 * ACg
	 *
	 * w肳ꂽoCg̃ACg܂0o܂B
	 * @param size ACgƂoCg
	 * @return 0ooCg
	 */
	int align(int size){
		Assert(stream_ != NULL);
		return stream_->align(size);
	}

	/**
	 * tbV
	 *
	 * Xg[tbV܂B
	 */
	void flush(){
		Assert(stream_ != NULL);
		stream_->flush();
	}

	/**
	 * ݈ʒu̎擾
	 * @return ݈ʒu
	 */
	int getPosition(){
		Assert(stream_ != NULL);
		return stream_->getPosition();
	}

	/**
	 * ݈ʒu̐ݒ
	 *
	 * w肳ꂽʒuɏ݈ʒuύX܂B
	 * @param position ݈ʒu
	 */
	void setPosition(int position){
		Assert(stream_ != NULL);
		stream_->setPosition(position);
	}

protected:
	/**
	 * RXgN^
	 */
	Writer(){ stream_ = NULL; }

	/**
	 * fXgN^
	 */
	virtual ~Writer(){
		Assert(stream_ != NULL);
		delete stream_;
		stream_ = NULL;
	}

	/// o̓Xg[
	OutputStream* stream_;

private:
	// Rs[RXgN^̉B
	Writer(const Writer& copy);

	// Rs[̉B
	void operator =(const Writer& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of WRITER_H_
//------------------------------------------------------------------------------
