//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eLXgC^wb_
 * @author Junpee
 */

#ifndef TEXT_WRITER_H_
#define TEXT_WRITER_H_

#include <Core/InputOutput/Writer.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * eLXgC^
 */
class TextWriter : public Writer{
public:
	/**
	 * fXgN^
	 */
	virtual ~TextWriter();

	/**
	 * eLXg̏o
	 *
	 * StringeLXgf[^Ƃďo܂B
	 * \\n\\r\\nɕϊďo͂܂B
	 * NULL͏o͂܂B
	 * @param text oeLXg
	 */
	virtual void writeText(const String& text);

	/**
	 * eLXg̏o
	 *
	 * NULLŏIcharzeLXgf[^Ƃďo܂B
	 * \\n\\r\\nɕϊďo͂܂B
	 * NULL͏o͂܂B
	 * @param text oeLXg
	 */
	virtual void writeText(const char* text);

	/**
	 * eLXg̏o
	 *
	 * w肳ꂽTCYAcharzeLXgf[^Ƃďo܂B
	 * \\n\\r\\nɕϊďo͂܂B
	 * @param text oeLXg
	 * @param size oTCY
	 */
	// t@CȊÕXg[ɑ΂ĉsϊKvƂȂ̂ł
	// ƃVvɂł
	virtual void writeText(const char* text, int size);

	/**
	 * tH[}bgeLXg̏o
	 *
	 * printf()\ŃtH[}bgeLXgf[^o܂B
	 * \\n\\r\\nɕϊďo͂܂B
	 * @param format tH[}bg
	 * @param ... ϒ
	 */
	virtual void writeFormat(const char* format, ...);

protected:
	/**
	 * RXgN^
	 */
	TextWriter();

private:
	// ftHgobt@TCY
	static const int defaultBufferSize = 1024;
	// tH[}bgftHgobt@TCY
	static const int formatDefaultBufferSize = 1024;

	// obt@
	char* buffer_;
	// obt@TCY
	int bufferSize_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of TEXT_WRITER_H_
//------------------------------------------------------------------------------
