//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eLXg[_wb_
 * @author Junpee
 */

#ifndef TEXT_READER_H_
#define TEXT_READER_H_

#include <Core/InputOutput/Reader.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * eLXg[_
 */
class TextReader : public Reader{
public:
	/**
	 * fXgN^
	 */
	virtual ~TextReader();

	/**
	 * eLXg[_̕
	 * @return ꂽeLXg[_
	 */
	virtual TextReader* cloneTextReader() = 0;

	/**
	 * [_̕
	 * @return ꂽ[_
	 */
	virtual Reader* cloneReader(){ return cloneTextReader(); }

	/**
	 * ̈sǂݍ
	 *
	 * ̃\bhgpƁAsR[h̕ϊs܂B
	 * @return ǂݏo
	 */
	 virtual String readLine();

protected:
	/**
	 * RXgN^
	 * @param bufferSize obt@TCY
	 */
	TextReader(int bufferSize = 4096);

	/**
	 * obt@TCY̎擾
	 * @return obt@TCY
	 */
	int getBufferSize() const{ return bufferSize_; }

	/**
	 * eLXg[_f[^̃Rs[
	 * @param destination Rs[eLXg[_
	 */
	virtual void copyTextReaderData(TextReader* destination);

private:
	// obt@
	char* buffer_;
	// o
	char* output_;
	// obt@TCY
	int bufferSize_;
	// ǂݍ݃TCY
	int readSize_;
	// ʒu
	int position_;
	// t@Cʒu
	int filePosition_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of TEXT_READER_H_
//------------------------------------------------------------------------------
