//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Xg[g[NiCUwb_
 * @author Junpee
 */

#ifndef STREAM_TOKENIZER_H_
#define STREAM_TOKENIZER_H_

#include <Core/Utility/StringTokenizer.h>

namespace Lamp{

class TextReader;

//------------------------------------------------------------------------------
/**
 * Xg[g[NiCU
 */
class StreamTokenizer{
public:
	/**
	 * RXgN^
	 * @param reader eLXg[_
	 * @param delimiter f~^As͋IɃf~^ƂȂ܂B
	 */
	StreamTokenizer(TextReader* reader,
		const String& delimiter = defaultDelimiter);

	/**
	 * fXgN^
	 */
	virtual ~StreamTokenizer();

	/**
	 * ̃g[N
	 * @return trueȂg[NB
	 */
	virtual bool nextToken();

	/**
	 * g[N擾
	 * @return g[N
	 */
	virtual String getToken() const{ return nowToken_; }

	/**
	 * Õg[N擾
	 * @return Õg[N
	 */
	virtual String getPreviousToken() const{ return previousToken_; }

	/**
	 * XbVXbVRgtO̐ݒ
	 * @param slashSlash XbVXbVRgLɂȂtrue
	 */
	virtual void setSlashSlashCommentFlag(bool slashSlash){
		slashSlash_ = slashSlash;
	}

	/**
	 * XbVXbVRgtO̎擾
	 * @return XbVXbVRgLȂtrue
	 */
	virtual bool getSlashSlashCommentFlag(){ return slashSlash_; }

	/**
	 * XbVX^[RgtO̐ݒ
	 * @param slashStar XbVX^[RgLɂȂtrue
	 */
	virtual void setSlashStarCommentFlag(bool slashStar){
		slashStar_ = slashStar;
	}

	/**
	 * XbVX^[RgtO̎擾
	 * @return XbVX^[RgLȂtrue
	 */
	virtual bool getSlashStarCommentFlag(){ return slashStar_; }

	/**
	 * sԍ̎擾
	 * @return sԍ
	 */
	virtual int getLineNumber(){ return lineNumber_; }

private:

	// Rs[RXgN^̉B
	StreamTokenizer(const StreamTokenizer& copy);

	// Rs[̉B
	void operator =(const StreamTokenizer& copy);

	bool checkTokenzier();

	// eLXg[_
	TextReader* reader_;
	// g[NiCU
	StringTokenizer tokenizer_;
	// f~^
	String delimiter_;
	// ݂̃g[N
	String nowToken_;
	// Õg[N
	String previousToken_;
	// XbVXbVRg
	bool slashSlash_;
	// XbVX^[Rg
	bool slashStar_;
	// Cԍ
	int lineNumber_;

	// ftHgf~^
	static const String defaultDelimiter;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of STREAM_TOKENIZER_H_
//------------------------------------------------------------------------------
