//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * [_wb_
 * @author Junpee
 */

#ifndef READER_H_
#define READER_H_

#include <Core/InputOutput/InputStream.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * [_
 *
 * f[^ǂݍ݂̃C^[tF[X
 */
class Reader{
public:
	/**
	 * I[ǂ
	 * @return trueȂI[
	 */
	bool isEnd(){
		Assert(stream_ != NULL);
		return stream_->isEnd();
	}

	/**
	 * oCgf[^̓ǂݏo
	 * @param data ǂݏoAhX
	 * @param size ǂݏoTCY
	 */
	void readBytes(void* data, int size){
		Assert(stream_ != NULL);
		stream_->readBytes(data, size);
	}

	/**
	 * TCY̎擾
	 * @return ǂݍ߂oCg
	 */
	int getSize(){
		Assert(stream_ != NULL);
		return stream_->getSize();
	}

	/**
	 * XLbv
	 *
	 * w肳ꂽoCgǂݔ΂܂B
	 * @param size ǂݔ΂oCg
	 */
	void skip(int size){
		Assert(stream_ != NULL);
		stream_->skip(size);
	}

	/**
	 * ACg
	 *
	 * w肳ꂽoCg̃ACg܂œǂݍ݈ʒu炵܂B
	 * @param size ACgƂoCg
	 * @return 炵oCg
	 */
	int align(int size){
		Assert(stream_ != NULL);
		return stream_->align(size);
	}

	/**
	 * ǂݍ݈ʒu̎擾
	 * @return ǂݍ݈ʒu
	 */
	int getPosition(){
		Assert(stream_ != NULL);
		return stream_->getPosition();
	}

	/**
	 * ǂݍ݈ʒu̐ݒ
	 *
	 * w肳ꂽʒuɓǂݍ݈ʒuύX܂B
	 * @param position ǂݍ݈ʒu
	 */
	void setPosition(int position){
		Assert(stream_ != NULL);
		stream_->setPosition(position);
	}

	/**
	 * [_̕
	 * @return ꂽ[_
	 */
	virtual Reader* cloneReader() = 0;

protected:
	/**
	 * RXgN^
	 */
	Reader(){ stream_ = NULL; }

	/**
	 * fXgN^
	 */
	virtual ~Reader(){
		Assert(stream_ != NULL);
		delete stream_;
		stream_ = NULL;
	}

	/// ̓Xg[
	InputStream* stream_;

private:
	// Rs[RXgN^̉B
	Reader(const Reader& copy);

	// Rs[̉B
	void operator =(const Reader& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of READER_H_
//------------------------------------------------------------------------------
