//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * o̓Xg[wb_
 * @author Junpee
 */

#ifndef OUTPUT_STREAM_H_
#define OUTPUT_STREAM_H_

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * o̓Xg[
 */
class OutputStream{
friend class Writer;
public:
	/**
	 * RXgN^
	 */
	OutputStream(){}

	/**
	 * fXgN^
	 */
	virtual ~OutputStream(){}

protected:
	/**
	 * oCgf[^̏o
	 * @param data ooCgf[^
	 * @param size oTCY
	 */
	virtual void writeBytes(const void* data, int size) = 0;

	/**
	 * TCY̎擾
	 * @return 񂾃oCg
	 */
	virtual int getSize() = 0;

	/**
	 * XLbv
	 *
	 * w肳ꂽoCgA0o܂B
	 * @param size 0ooCg
	 */
	virtual void skip(int size) = 0;

	/**
	 * ACg
	 *
	 * w肳ꂽoCg̃ACg܂0o܂B
	 * @param size ACgƂoCg
	 * @return 0ooCg
	 */
	virtual int align(int size) = 0;

	/**
	 * ݈ʒu̎擾
	 * @return ݈ʒu
	 */
	virtual int getPosition() = 0;

	/**
	 * ݈ʒu̐ݒ
	 *
	 * w肳ꂽʒuɏ݈ʒuύX܂B
	 * @param position ݈ʒu
	 */
	virtual void setPosition(int position) = 0;

	/**
	 * tbV
	 *
	 * Xg[tbV܂B
	 */
	virtual void flush() = 0;

private:
	// Rs[RXgN^̉B
	OutputStream(const OutputStream& copy);

	// Rs[̉B
	void operator =(const OutputStream& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of OUTPUT_STREAM_H_
//------------------------------------------------------------------------------
