//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * o̓Xg[wb_
 * @author Junpee
 */

#ifndef MEMORY_OUTPUT_STREAM_H_
#define MEMORY_OUTPUT_STREAM_H_

#include <Core/InputOutput/OutputStream.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * o̓Xg[
 */
class MemoryOutputStream : public OutputStream{
public:
	/**
	 * RXgN^
	 * @param bufferInitialSize obt@TCY
	 */
	explicit MemoryOutputStream(int bufferInitialSize);

	/**
	 * fXgN^
	 */
	virtual ~MemoryOutputStream();

	/**
	 * obt@̎擾
	 *
	 * obt@擾܂B
	 * ̃obt@͂̃NXfXgNg鎞ɏ܂B
	 * @return obt@
	 */
	virtual const char* getBuffer(){ return buffer_; }

protected:
	/**
	 * oCgf[^̏o
	 * @param data ooCgf[^
	 * @param size oTCY
	 */
	virtual void writeBytes(const void* data, int size);

	/**
	 * TCY̎擾
	 * @return 񂾃oCg
	 */
	virtual int getSize();

	/**
	 * XLbv
	 *
	 * w肳ꂽoCgA0o܂B
	 * @param size 0ooCg
	 */
	virtual void skip(int size);

	/**
	 * ACg
	 *
	 * w肳ꂽoCg̃ACg܂0o܂B
	 * @param alignSize ACgƂoCg
	 * @return 0ooCg
	 */
	virtual int align(int alignSize);

	/**
	 * ݈ʒu̎擾
	 * @return ݈ʒu
	 */
	virtual int getPosition();

	/**
	 * ݈ʒu̐ݒ
	 *
	 * w肳ꂽʒuɏ݈ʒuύX܂B
	 * @param position ݈ʒu
	 */
	virtual void setPosition(int position);

	/**
	 * tbV
	 *
	 * Xg[tbV܂B
	 */
	virtual void flush();

private:
	// Rs[RXgN^̉B
	MemoryOutputStream(const MemoryOutputStream& copy);

	// Rs[̉B
	void operator =(const MemoryOutputStream& copy);

	// obt@`FbN
	void bufferCheck(int size);

	// obt@
	char* buffer_;
	// obt@TCY
	int bufferSize_;
	// ʒu
	int position_;
	// TCY
	int size_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of MEMORY_OUTPUT_STREAM_H_
//------------------------------------------------------------------------------
