//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ̓Xg[wb_
 * @author Junpee
 */

#ifndef INPUT_STREAM_H_
#define INPUT_STREAM_H_

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * ̓Xg[
 */
class InputStream{
friend class Reader;
public:
	/**
	 * RXgN^
	 */
	InputStream(){}

	/**
	 * fXgN^
	 */
	virtual ~InputStream(){}

	/**
	 * ̓Xg[̕
	 * @return ꂽ̓Xg[
	 */
	virtual InputStream* cloneInputStream() = 0;

protected:
	/**
	 * I[ǂ
	 * @return trueȂI[
	 */
	virtual bool isEnd() = 0;

	/**
	 * oCgf[^̓ǂݍ
	 * @param data ǂݏoAhX
	 * @param size ǂݏoTCY
	 */
	virtual void readBytes(void* data, int size) = 0;

	/**
	 * TCY̎擾
	 * @return Xg[Ŝ̃oCg
	 */
	virtual int getSize() = 0;

	/**
	 * XLbv
	 *
	 * w肳ꂽoCgAǂݏoXLbv܂B
	 * @param size XLbvoCg
	 */
	virtual void skip(int size) = 0;

	/**
	 * ACg
	 *
	 * w肳ꂽoCg̃ACg܂œǂݔ΂܂B
	 * @param size ACgƂoCg
	 * @return XLbvoCg
	 */
	virtual int align(int size) = 0;

	/**
	 * ǂݍ݈ʒu̎擾
	 * @return ǂݍ݈ʒu
	 */
	virtual int getPosition() = 0;

	/**
	 * ǂݍ݈ʒu̐ݒ
	 *
	 * w肳ꂽʒuɓǂݍ݈ʒuύX܂B
	 * @param position ǂݍ݈ʒu
	 */
	virtual void setPosition(int position) = 0;

private:
	// Rs[RXgN^̉B
	InputStream(const InputStream& copy);

	// Rs[̉B
	void operator =(const InputStream& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of INPUT_STREAM_H_
//------------------------------------------------------------------------------
