//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * t@C̓Xg[wb_
 * @author Junpee
 */

#ifndef FILE_INPUT_STREAM_H_
#define FILE_INPUT_STREAM_H_

#include <cstdio>
#include <Core/InputOutput/InputStream.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * t@C̓Xg[
 */
class FileInputStream : public InputStream{
public:
	/**
	 * RXgN^
	 */
	explicit FileInputStream(String fileName);

	/**
	 * fXgN^
	 */
	virtual ~FileInputStream();

	/**
	 * t@C̓Xg[̕
	 * @return ꂽt@C̓Xg[
	 */
	virtual FileInputStream* cloneFileInputStream();

	/**
	 * ̓Xg[̕
	 * @return ꂽ̓Xg[
	 */
	virtual InputStream* cloneInputStream(){ return cloneFileInputStream(); }

protected:
	/**
	 * I[ǂ
	 * @return trueȂI[
	 */
	virtual bool isEnd();

	/**
	 * oCgf[^̓ǂݏo
	 * @param data ǂݏoAhX
	 * @param size ǂݏoTCY
	 */
	virtual void readBytes(void* data, int size);

	/**
	 * TCY̎擾
	 * @return Xg[Ŝ̃oCg
	 */
	virtual int getSize();

	/**
	 * XLbv
	 *
	 * w肳ꂽoCgAǂݏoXLbv܂B
	 * @param size XLbvoCg
	 */
	virtual void skip(int size);

	/**
	 * ACg
	 *
	 * w肳ꂽoCg̃ACg܂œǂݔ΂܂B
	 * @param alignSize ACgƂoCg
	 * @return XLbvoCg
	 */
	virtual int align(int alignSize);

	/**
	 * ǂݍ݈ʒu̎擾
	 * @return ǂݍ݈ʒu
	 */
	virtual int getPosition();

	/**
	 * ǂݍ݈ʒu̐ݒ
	 *
	 * w肳ꂽʒuɓǂݍ݈ʒuύX܂B
	 * @param position ǂݍ݈ʒu
	 */
	virtual void setPosition(int position);

private:
	// Rs[RXgN^̉B
	FileInputStream(const FileInputStream& copy);

	// Rs[̉B
	void operator =(const FileInputStream& copy);

	// t@C
	String fileName_;
	// t@C|C^
	FILE* file_;
	// ʒu
	int position_;
	// TCY
	int size_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of FILE_INPUT_STREAM_H_
//------------------------------------------------------------------------------
