//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * oCiC^wb_
 * @author Junpee
 */

#ifndef BINARY_WRITER_H_
#define BINARY_WRITER_H_

#include <Core/InputOutput/Writer.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * oCiC^
 */
class BinaryWriter : public Writer{
public:
	/**
	 * fXgN^
	 */
	virtual ~BinaryWriter();

	/**
	 * bool̏o
	 * @param value ol
	 */
	virtual void writeBool(bool value);

	/**
	 * chaȑo
	 * @param value ol
	 */
	virtual void writeChar(char value);

	/**
	 * u_chaȑo
	 * @param value ol
	 */
	virtual void writeUChar(u_char value);

	/**
	 * short̏o
	 * @param value ol
	 */
	virtual void writeShort(short value);

	/**
	 * u_short̏o
	 * @param value ol
	 */
	virtual void writeUShort(u_short value);

	/**
	 * int̏o
	 * @param value ol
	 */
	virtual void writeInt(int value);

	/**
	 * u_int̏o
	 * @param value ol
	 */
	virtual void writeUInt(u_int value);

	/**
	 * float̏o
	 * @param value ol
	 */
	virtual void writeFloat(float value);

	/**
	 * doublȅo
	 * @param value ol
	 */
	virtual void writeDouble(double value);

	/**
	 * String̏o
	 *
	 * StringNXoCif[^Ƃďo܂B
	 * @param string oString
	 */
	virtual void writeString(const String& string);

	/**
	 * z̏o
	 * @param array oz
	 * @param elementSize vf̃TCY
	 * @param elementCount vf̐
	 */
	virtual void writeArray(
		const void* array, int elementSize, int elementCount);

protected:
	/**
	 * RXgN^
	 */
	BinaryWriter();

private:
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of BINARY_WRITER_H_
//------------------------------------------------------------------------------
