//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * oCi[_wb_
 * @author Junpee
 */

#ifndef BINARY_READER_H_
#define BINARY_READER_H_

#include <Core/InputOutput/Reader.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * oCi[_
 */
class BinaryReader : public Reader{
public:
	/**
	 * fXgN^
	 */
	virtual ~BinaryReader();

	/**
	 * oCi[_̕
	 * @return ꂽoCi[_
	 */
	virtual BinaryReader* cloneBinaryReader() = 0;

	/**
	 * [_̕
	 * @return ꂽ[_
	 */
	virtual Reader* cloneReader(){ return cloneBinaryReader(); }

	/**
	 * bool̓ǂݍ
	 * @return ǂݍ񂾒l
	 */
	virtual bool readBool();

	/**
	 * char̓ǂݍ
	 * @return ǂݍ񂾒l
	 */
	virtual char readChar();

	/**
	 * u_char̓ǂݍ
	 * @return ǂݍ񂾒l
	 */
	virtual u_char readUChar();

	/**
	 * short̓ǂݍ
	 * @return ǂݍ񂾒l
	 */
	virtual short readShort();

	/**
	 * u_short̓ǂݍ
	 * @return ǂݍ񂾒l
	 */
	virtual u_short readUShort();

	/**
	 * int̓ǂݍ
	 * @return ǂݍ񂾒l
	 */
	virtual int readInt();

	/**
	 * u_int̓ǂݍ
	 * @return ǂݍ񂾒l
	 */
	virtual u_int readUInt();

	/**
	 * float̓ǂݍ
	 * @return ǂݍ񂾒l
	 */
	virtual float readFloat();

	/**
	 * double̓ǂݍ
	 * @return ǂݍ񂾒l
	 */
	virtual double readDouble();

	/**
	 * String̓ǂݍ
	 * @return ǂݍ񂾕
	 */
	virtual const String readString();

	/**
	 * z̓ǂݍ
	 * @param array ǂݍݐz
	 * @param elementSize vf̃TCY
	 * @param elementCount vf̐
	 */
	virtual void readArray(
		void* array, int elementSize, int elementCount);

protected:
	/**
	 * RXgN^
	 */
	BinaryReader();

private:

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of BINARY_READER_H_
//------------------------------------------------------------------------------
