//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * oCiC^wb_
 * @author Junpee
 */

#ifndef BINARY_MEMORY_WRITER_H_
#define BINARY_MEMORY_WRITER_H_

#include <Core/InputOutput/BinaryWriter.h>
#include <Core/InputOutput/MemoryOutputStream.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * oCiC^
 */
class BinaryMemoryWriter : public BinaryWriter{
public:
	/**
	 * RXgN^
	 * @param bufferInitialSize obt@TCY
	 */
	explicit BinaryMemoryWriter(int bufferInitialSize = 1024){
		stream_ = new MemoryOutputStream(bufferInitialSize);
	}

	/**
	 * obt@̎擾
	 *
	 * obt@擾܂B
	 * ̃obt@͂̃NXfXgNg鎞ɏ܂B
	 * @return obt@
	 */
	virtual const char* getBuffer(){
		return ((MemoryOutputStream*)stream_)->getBuffer();
	}

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of BINARY_MEMORY_WRITER_H_
//------------------------------------------------------------------------------
