//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * oCit@C[_wb_
 * @author Junpee
 */

#ifndef BINARY_FILE_READER_H_
#define BINARY_FILE_READER_H_

#include <Core/InputOutput/BinaryReader.h>
#include <Core/InputOutput/FileInputStream.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * oCit@C[_
 */
class BinaryFileReader : public BinaryReader{
public:
	/**
	 * RXgN^
	 */
	explicit BinaryFileReader(String fileName){
		stream_ = new FileInputStream(fileName);
	}

	/**
	 * oCit@C[_̕
	 * @return ꂽoCit@C[_
	 */
	virtual BinaryFileReader* cloneBinaryFileReader(){
		BinaryFileReader* binaryFileReader = new BinaryFileReader();
		binaryFileReader->stream_ = stream_->cloneInputStream();
		return binaryFileReader;
	}

	/**
	 * oCi[_̕
	 * @return ꂽoCi[_
	 */
	virtual BinaryReader* cloneBinaryReader(){
		return cloneBinaryFileReader();
	}

protected:
	/**
	 * RXgN^
	 */
	BinaryFileReader(){}

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of BINARY_FILE_READER_H_
//------------------------------------------------------------------------------
