//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * `FbJwb_
 * @author Junpee
 */

#ifndef MEMORY_CHECKER_H_
#define MEMORY_CHECKER_H_

//------------------------------------------------------------------------------
// fobO
#ifdef _DEBUG

/// fobOŃAP[^LɂB
#include <memory>
#define _CRTDBG_MAP_ALLOC
#include <crtdbg.h>

/// newɃfobOtB
#define new  ::new(_NORMAL_BLOCK, __FILE__, __LINE__)

namespace Lamp{

/**
 * `FbJ
 *
 * [NõׂNXłB<br>
 * VXe MemoryChecker::initialize()ĂŉB
 * <pre>
 * TvR[h
 *
 * // 
 * MemoryChecker::initialize();
 *
 * // ̏ڍׂȏ_v
 * MemoryChecker::dumpDetail();
 * // ̓v_v
 * MemoryChecker::dumpStatistics();
 *
 * // ݂̃Xe[g擾
 * MemoryChecker::State state = MemoryChecker::getState();
 *
 * // gp鏈
 * allocateMemoryMethod();
 *
 * // allocateMemoryMethod()Ŏgp̏ڍׂȏ_v
 * MemoryChecker::dumpDetail(state);
 * // allocateMemoryMethod()Ŏgp̓v_v
 * MemoryChecker::dumpStatistics(state);
 *
 * // 鏈
 * freeMemoryMethod();
 *
 * // freeMemoryMethodłƃĂ邩`FbN
 * MemoryChecker::leakCheck(state);
 * </pre>
 */
//------------------------------------------------------------------------------
class MemoryChecker{
public:
	/**
	 * 
	 *
	 * VXȅɈxĂŉB
	 */
	static void initialize();

	/**
	 * Xe[g
	 *
	 * ̏ԂNXɕۑ܂B
	 */
	class State{
	friend class MemoryChecker;
	private:
		_CrtMemState state;
	};

	/**
	 * Xe[g̎擾
	 * @return Xe[g
	 */
	static State getState();

	/**
	 * ڍ׃_v
	 *
	 * ̏ڍׂȏfobOo͂Ƀ_v܂B
	 */
	static void dumpDetail();

	/**
	 * ڍׂ̍_v
	 *
	 * ̏ڍׂȏfobOo͂Ƀ_v܂B
	 * @param oldState ȑÕXe[g
	 */
	static void dumpDetail(const State& oldState);

	/**
	 * ṽ_v
	 *
	 * ̓vfobOo͂Ƀ_v܂B
	 */
	static void dumpStatistics();

	/**
	 * v̍_v
	 *
	 * ̓vfobOo͂Ƀ_v܂B
	 * @param oldState ȑÕXe[g
	 */
	static void dumpStatistics(const State& oldState);

	/**
	 * [N`FbN
	 *
	 * [N`FbN܂B
	 * gpʂꍇ̓[Noł܂B
	 * gpʂŃ[NoɂdumpDetailgpĂB
	 * @param oldState ȑÕXe[g
	 @ @return trueȂ烁[NĂB
	 */
	static bool leakCheck(const State& oldState);

private:
	// RXgN^B
	MemoryChecker(){}

	// tO
	static bool initialized_;
};

} // End of namespace Lamp

//------------------------------------------------------------------------------
// fobO
#else // ! _DEBUG

// fobO؂ɃRpCG[Ԃւ̑΍
#include <memory>

namespace Lamp{

/// 
class MemoryChecker{
public:
	/// _~[
	inline static void initialize(){}

	/// Xe[g
	class State{};

	/// Xe[g̎擾_~[
	inline static State getState(){
		State state;
		return state;
	}

	/// ڍ׃_v_~[
	inline static void dumpDetail(){}

	/// ڍׂ̍_v_~[
	inline static void dumpDetail(State oldState){}

	/// ṽ_v_~[
	inline static void dumpStatistics(){}

	/// v̍_v_~[
	inline static void dumpStatistics(State oldState){}

	/// [N`FbN_~[
	inline static bool leakCheck(State oldState){ return false; }

private:
	// RXgN^B
	MemoryChecker(){}
};

} // End of namespace Lamp

#endif // End of _DEBUG

//------------------------------------------------------------------------------
#endif // End of MEMORY_CHECKER_H_
//------------------------------------------------------------------------------
