//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * K[wb_
 * @author Junpee
 */

#ifndef LOGGER_H_
#define LOGGER_H_

namespace Lamp{

class TextFileWriter;

//------------------------------------------------------------------------------
/**
 * K[
 */
class Logger{
public:
	/// Ȍo̓x
	enum LogLevel{
		/// OoȂ
		zeroLevel = 0,
		/// Œ̃O
		fewLevel = 1,
		/// ʂ̃O
		midiumLevel = 2,
		/// ̃O
		manyLevel = 3,
	};
	/**
	 * RXgN^
	 * @param fileName Ot@C
	 * @param logLevel Ox
	 */
	explicit Logger(const String& fileName, LogLevel logLevel = midiumLevel);

	/**
	 * fXgN^
	 */
	virtual ~Logger();

	/**
	 * Oo
	 * @param logLevel Ox
	 * @param message o̓bZ[W
	 */
	virtual void output(LogLevel logLevel, String message);

	/**
	 * Oo
	 *
	 * ʂ̃Oxŏo͂܂B
	 * @param message o̓bZ[W
	 */
	virtual void output(String message){ output(midiumLevel, message); }

	/**
	 * Oo
	 * @param logLevel Ox
	 * @param format tH[}bg
	 * @param ... ϒ
	 */
	virtual void output(LogLevel logLevel, const char* format, ...);

	/**
	 * Oo
	 *
	 * ʂ̃Oxŏo͂܂B
	 * @param format tH[}bg
	 * @param ... ϒ
	 */
	virtual void output(const char* format, ...);

	/**
	 * tbV
	 */
	virtual void flush();

	/**
	 * Ox̐ݒ
	 * @param logLevel ݒ肷郍Ox
	 */
	virtual void setLogLevel(LogLevel logLevel){ logLevel_ = logLevel; }

	/**
	 * Ox̎擾
	 * @return Ox
	 */
	virtual LogLevel getLogLevel(){ return logLevel_; }

private:
	// Rs[RXgN^̉B
	Logger(const Logger& copy);

	// Rs[̉B
	void operator =(const Logger& copy);

	// C^
	TextFileWriter* writer_;
	// Ox
	LogLevel logLevel_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of LOGGER_H_
//------------------------------------------------------------------------------
