//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * G[o̓wb_
 * @author Junpee
 */
#ifndef ERROR_OUTPUT_H_
#define ERROR_OUTPUT_H_

//------------------------------------------------------------------------------

/**
 * G[o͂̏
 */
#define ErrorOutInitialize ::Lamp::ErrorOutput::initialize

/**
 * G[o͂̌n
 */
#define ErrorOutFinalize ::Lamp::ErrorOutput::finalize

/**
 * G[o
 *
 * printfƓ\ŌĂяoƁAG[nhĂяo܂B
 * ftHg̃G[nh̓bZ[Wo͂AI܂B
 * <pre>
 * TvR[h
 *
 * // uHoge 1 2.0vƂbZ[WŃG[𔭐B
 * ErrorOut("Hoge %d %.1f", 1, 2.f);
 * </pre>
 */
#define ErrorOut ::Lamp::ErrorOutput::print

/**
 * ̏o
 *
 * G[ɃG[o͂ɐo͂As܂B
 */
#define ErrorOutLine() ::Lamp::ErrorOutput::print("------------------------------"\
	"--------------------------------------------------\n")

/**
 * ̏o
 *
 * G[ɃG[o͂ɑo͂As܂B
 */
#define ErrorOutThickLine() ::Lamp::ErrorOutput::print("##############################"\
	"##################################################\n")

namespace Lamp{

class Logger;
class String;

/**
 * G[o̓NX
 *
 * G[o͂̎NXłB
 */
class ErrorOutput{
public:
	/**
	 * 
	 * @param fileName G[Ot@CBNULLƃOc܂B
	 */
	static void initialize(const char* fileName = "LampErrorLog.txt");

	/**
	 * n
	 */
	static void finalize();

	/**
	 * G[o
	 *
	 * ϒɑΉG[o̓\bhB
	 * @param format tH[}bg
	 * @param ... ϒ
	 * @return o͕
	 */
	static int print(const char* format, ...);

	/**
	 * G[o
	 * @param string 
	 * @return o͕
	 */
	static int print(const String& string);

	/**
	 * G[nȟ^
	 *
	 * ftHg̃G[nh̓bZ[Wo͂ċI܂B
	 * @param message G[bZ[W
	 */
	typedef void (*ErrorHandler)(const char* message);

	/**
	 * G[nh̐ݒ
	 * @param handler ݒ肷G[nh
	 */
	static void setErrorHandler(ErrorHandler handler){ handler_ = handler; }

private:
	// ftHgG[nh
	static void defaultErrorHandler(const char* message);

	// RXgN^B
	ErrorOutput();

	// G[nh
	static ErrorHandler handler_;
	// K[
	static Logger* logger_;
};

} // End of namespace Lamp

//------------------------------------------------------------------------------
#endif // End of ERROR_OUTPUT_H_
//------------------------------------------------------------------------------
