//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * fobOo̓wb_
 * @author Junpee
 */
#ifndef DEBUG_OUTPUT_H_
#define DEBUG_OUTPUT_H_

//------------------------------------------------------------------------------
// fobO
#ifdef _DEBUG

/**
 * fobOo͂̏
 */
#define DebugOutInitialize() ::Lamp::DebugOutput::initialize()

/**
 * fobOo͂̌n
 */
#define DebugOutFinalize() ::Lamp::DebugOutput::finalize()


/**
 * fobOo
 *
 * fobOprintfƓ\ŌĂяoƁAfobOo͂ɃbZ[Wo͂܂B
 * <pre>
 * TvR[h
 *
 * // fobOAfobOo͂ɁuHoge 1 2.0vƏo͂ĉsB
 * DebugOut("Hoge %d %.1f\n", 1, 2.f);
 * </pre>
 */
#define DebugOut ::Lamp::DebugOutput::print

/**
 * ̏o
 *
 * fobOɃfobOo͂ɐo͂As܂B
 */
#define DebugOutLine() ::Lamp::DebugOutput::print("------------------------------"\
	"--------------------------------------------------\n")

/**
 * ̏o
 *
 * fobOɃfobOo͂ɑo͂As܂B
 */
#define DebugOutThickLine() ::Lamp::DebugOutput::print("##############################"\
	"##################################################\n")

namespace Lamp{

class String;

/**
 * fobOo̓NX
 *
 * fobOo͂̎NXłB
 */
class DebugOutput{
public:
	/**
	 * 
	 * @param fileName fobOOt@CBNULLƃOc܂B
	 */
	static void initialize(const char* fileName = "LampDebugLog.txt");

	/**
	 * n
	 */
	static void finalize();

	/**
	 * fobOo
	 *
	 * ϒɑΉfobOo̓\bhB
	 * @param format tH[}bg
	 * @param ... ϒ
	 * @return o͕
	 */
	static int print(const char* format, ...);

	/**
	 * fobOo
	 * @param string 
	 * @return o͕
	 */
	static int print(const String& string);

private:
	// RXgN^B
	DebugOutput();

	// K[
	static Logger* logger_;
};

} // End of namespace Lamp

//------------------------------------------------------------------------------
// fobO
#else // ! _DEBUG

// fobOo͂̏_~[
#define DebugOutInitialize()

// fobOo͂̌n_~[
#define DebugOutFinalize()

/// o̓_~[
#define DebugOut

/// ̏o̓_~[
#define DebugOutLine()

/// ̏o̓_~[
#define DebugOutThickLine()

#endif// End of _DEBUG

//------------------------------------------------------------------------------
#endif // End of DEBUG_OUTPUT_H_
//------------------------------------------------------------------------------
