//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * AT[gwb_
 * @author Junpee
 */
#ifndef ASSERT_H_
#define ASSERT_H_
//------------------------------------------------------------------------------
// fobO
#ifdef _DEBUG

/**
 * AT[g
 * @param expression falseƃAT[g܂
 *
 * AT[g̈falsȅꍇAAT[gfobKu[N܂B
 * ăAT[gt@CƍsfobOo͂ɏo͂܂B
 */
#define Assert(expression) \
	if(!(expression)){\
		DebugOut("Assert %s %d\n", __FILE__, __LINE__);\
		_asm{ int 3 }\
	}

/**
 * bZ[WtAT[g
 * @param expression falseƃAT[g܂
 * @param message AT[gɏo͂郁bZ[W
 *
 * AT[g̈falsȅꍇAAT[gfobKu[N܂B
 * ăbZ[WƁAAT[gt@CƍsfobOo͂ɏo͂܂B
 */
#define AssertMessage(expression, message) \
	if(!(expression)){\
		DebugOut("Assert %s\n%s %d\n", message, __FILE__, __LINE__);\
		_asm{ int 3 }\
	}

//------------------------------------------------------------------------------
// fobO
#else // _DEBUG

/// AT[g_~[
#define Assert(expression)

/// bZ[WtAT[g_~[
#define AssertMessage(expression, message)

#endif// End of _DEBUG

//------------------------------------------------------------------------------
#endif // End of ASSERT_H_
//------------------------------------------------------------------------------
