//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * OtIuWFNgf[^x[Xwb_
 * @author Junpee
 */

#ifndef NAMED_OBJECT_DATABASE_H_
#define NAMED_OBJECT_DATABASE_H_

#include <Core/Container/HashMap.h>
#include <Core/Container/Deque.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * OtIuWFNgf[^x[X
 */
template <typename Type>
class NamedObjectDatabase{
public:
	/**
	 * RXgN^
	 * @param capacity e
	 * @param loadFactor ׌W
	 */
	NamedObjectDatabase(int capacity = 256, float loadFactor = 0.75f) :
		hash_(capacity, loadFactor), array_(capacity){
	}

	/**
	 * fXgN^
	 */
	virtual ~NamedObjectDatabase(){
		Assert(hash_.getCount() == 0);
		Assert(array_.getCount() == 0);
	}

	//--------------------------------------------------------------------------
	// IuWFNg̒ǉƍ폜
	//--------------------------------------------------------------------------
	/**
	 * IuWFNg̒ǉ
	 * @param object ǉIuWFNg
	 * @return true
	 */
	virtual bool add(const String& name, Type* object){
		Assert(name.getSize() != 0);
		Assert(object != NULL);
		if(search(name) != NULL){ return false; }
		hash_.put(name, object);
		array_.pushBack(object);
		return true;
	}

	/**
	 * IuWFNg̍폜
	 * @param object 폜IuWFNg
	 * @return true
	 */
	virtual bool remove(const String& name, Type* object){
		Assert(name.getSize() != 0);
		Assert(object != NULL);
		Type* removeObject = search(name);
		if(removeObject == NULL){ return false; }
		if(removeObject != object){ return false; }
		if(array_.removeByValue(object) == -1){ return false; }
		if(hash_.remove(name) == NULL){ Assert(false); }
		return true;
	}

	/**
	 * NA
	 * @return 폜IuWFNg
	 */
	virtual int clear(){
		int result = getCount();
		array_.clear();
		hash_.clear();
		return result;
	}

	//--------------------------------------------------------------------------
	// IuWFNgւ̃ANZX
	//--------------------------------------------------------------------------
	/**
	 * IuWFNg̎擾
	 * @return IuWFNg
	 */
	virtual int getCount(){ return array_.getCount(); }

	/**
	 * IuWFNg̎擾
	 * @param index IuWFNg̃CfNX
	 * @return IuWFNg
	 */
	virtual Type* get(int index){ return array_.get(index); }

	/**
	 * IuWFNǧ
	 * @param name IuWFNg
	 * @return IuWFNg
	 */
	virtual Type* search(const String& name){ return hash_.get(name); }

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	NamedObjectDatabase(const NamedObjectDatabase& copy);

	// Rs[̉B
	void operator =(const NamedObjectDatabase& copy);

	// nbV
	HashMap<String, Type*> hash_;
	// z
	Deque<Type*> array_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of NAMED_OBJECT_DATABASE_H_
//------------------------------------------------------------------------------
