//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * nbV}bvwb_
 * @author Junpee
 */

#ifndef HASH_MAP_H_
#define HASH_MAP_H_

// ACXg
#include <Core/Container/ArrayList.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * nbV}bv
 *
 * ̃NX͌pȂŉB
 * HashKey͈ȉ4̃\bhĂKv܂B<br>
 * HashKey();<br>
 * HashKey& operator =(const HashKey& copy);<br>
 * bool equals(const HashKey& compare) const;<br>
 * u_int getHashCode() const;<br>
 * ValueType͒ʏ̓|C^^w肵ĉB
 */
template <typename HashKey, typename ValueType>
class HashMap{
public:
	//--------------------------------------------------------------------------
	/**
	 * nbVf[^
	 *
	 * zopNX
	 */
	template <typename HashKey, typename ValueType>
	class HashData{
	public:
		/// ftHgRXgN^
		HashData() : value_(NULL){}

		/// L[l
		HashKey key_;
		/// l
		ValueType value_;
	};

	//--------------------------------------------------------------------------
	// \zAj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param capacity e
	 * @param loadFactor ׌W
	 */
	explicit HashMap(int capacity = 16, float loadFactor = 0.75f) :
		capacity_(capacity), loadFactor_(loadFactor), count_(0){
		Assert(capacity_ > 0);
		maxSize_ = (int)(capacity_ * loadFactor_);
		array_ = new HashItem<HashKey, ValueType>[capacity_];
	}

	/**
	 * fXgN^
	 */
	~HashMap(){
		Assert(count_ == 0);
		delete[] array_;
	}

	/**
	 * N[
	 * @param destination N[nbV}bv
	 */
	void cloneTo(HashMap* destination) const{
		Assert(destination->getCount() == 0);
		destination->loadFactor_ = loadFactor_;
		destination->setCapacity(capacity_);
		for(int i = 0; i < capacity_; i++){
			HashItem<HashKey, ValueType>* item = &array_[i];
			// vf󂾂
			if(item->value_ == NULL){ continue; }
			while(true){
				destination->put(item->key_, item->value_);
				item = item->next_;
				if(item == NULL){ break; }
			}
		}
	}

	//--------------------------------------------------------------------------
	// ̎擾
	//--------------------------------------------------------------------------
	/**
	 * vf̎擾
	 * @return vf
	 */
	int getCount() const{ return count_; }

	/**
	 * 󂩂ǂ
	 * @return ȂtrueԂ
	 */
	bool isEmpty() const{ return (count_ == 0); }

	/**
	 * vf̎擾
	 * @param key 擾vf̃L[
	 * @return vfBYL[NULLB
	 */
	ValueType get(const HashKey& key) const{
		// nbVl̊o
		u_int hashCode = key.getHashCode();
		HashItem<HashKey, ValueType>* item;
		item = &array_[hashCode % capacity_];
		if(item->value_ == NULL){ return NULL; }
		while(true){
			if(item->key_.equals(key)){ return item->value_; }
			item = item->next_;
			if(item == NULL){ return NULL; }
		}
	}

	/**
	 * eʂ̎擾
	 * @return e
	 */
	int getCapacity() const{ return capacity_; }

	/**
	 * ׌W̎擾
	 * @return ׌W
	 */
	float getLoadFactor() const{ return loadFactor_; }

	/**
	 * z̎擾
	 * @param arrayList [out]f[^i[ArrayList
	 */
	void toArray(ArrayList< HashData<HashKey, ValueType> >* arrayList) const{
		if(count_ == 0){ return; }
		arrayList->clear(count_);
		for(int i = 0; i < capacity_; i++){
			HashItem<HashKey, ValueType>* item = &array_[i];
			if(item->value_ == NULL){ continue; }
			while(true){
				HashData<HashKey, ValueType> data;
				data.key_ = item->key_;
				data.value_ = item->value_;
				arrayList->add(data);
				item = item->next_;
				if(item == NULL){ break; }
			}
		}
	}

	//--------------------------------------------------------------------------
	// nbV}bv̕ύX
	//--------------------------------------------------------------------------
	/**
	 * vf̒ǉ
	 * @param key nbVL[BL[͓o^sB
	 * @param value i[lBNULL͕sB
	 * @return tureAłɓvffalseԂAl͒ǉȂB
	 */
	bool put(HashKey key, ValueType value){
		Assert(value != NULL);
		if(value == NULL){ return false; }
		// z̃TCY
		if(count_ + 1 > maxSize_){
			int newCapacity = capacity_ * 2;
			while(true){
				maxSize_ = (int)(newCapacity * loadFactor_);
				if(count_ + 1 <= maxSize_){ break; }
				newCapacity *= 2;
			}
			setCapacity(newCapacity);
		}
		// nbVl̊o
		u_int hashCode = key.getHashCode();
		// nbVlɂvfȂďIB
		HashItem<HashKey, ValueType>* item;
		item = &array_[hashCode % capacity_];
		if(item->value_ == NULL){
			item->key_ = key;
			item->value_ = value;
			count_++;
			return true;
		}
		while(true){
			// l`FbN
			if(item->key_.equals(key)){ return false; }
			// AP[VĒǉ
			if(item->next_ == NULL){
				HashItem<HashKey, ValueType>* newItem;
				newItem = new HashItem<HashKey, ValueType>(key, value);
				item->next_ = newItem;
				count_++;
				return true;
			}
			item = item->next_;
		}
	}

	/**
	 * vf̍폜
	 * @param key nbVL[
	 * @return 폜ꂽlBȂNULL
	 */
	ValueType remove(HashKey key){
		// nbVl̊o
		u_int hashCode = key.getHashCode();
		HashItem<HashKey, ValueType>* item = &array_[hashCode % capacity_];
		if(item->value_ == NULL){ return NULL; }
		// vf̍폜
		ValueType returnValue = NULL;
		if(item->key_.equals(key)){
			returnValue = item->value_;
			if(item->next_ == NULL){
				// 1Ԗڂ̗vf폜
				item->value_ = NULL;
				item->key_ = HashKey();
			}else{
				// 2Ԗڂ̗vf1Ԗڂɑč폜
				HashItem<HashKey, ValueType>* nextItem = item->next_;
				*item = *nextItem;
				delete nextItem;
			}
			count_--;
			return returnValue;
		}
		// vfȍ~̍폜
		HashItem<HashKey, ValueType>* nextItem;
		while(true){
			nextItem = item->next_;
			if(nextItem == NULL){ return NULL; }
			if(nextItem->key_.equals(key)){
				returnValue = nextItem->value_;
				item->next_ = nextItem->next_;
				delete nextItem;
				count_--;
				return returnValue;
			}
			item = nextItem;
		}
	}

	/**
	 * NA
	 */
	void clear(){
		for(int i = 0; i < capacity_; i++){
			HashItem<HashKey, ValueType>* item = &array_[i];
			HashItem<HashKey, ValueType>* nextItem = item->next_;
			// vf󂾂
			if(item->value_ == NULL){ continue; }
			item->key_ = HashKey();
			item->value_ = NULL;
			item->next_ = NULL;
			count_--;
			while(true){
				item = nextItem;
				if(item == NULL){ break; }
				nextItem = item->next_;
				item->key_ = HashKey();
				item->value_ = NULL;
				item->next_ = NULL;
				count_--;
				delete item;
			}
		}
	}

	/**
	 * eʂ̐ݒ
	 * @param capacity ݒ肷LpVeB
	 */
	void setCapacity(int capacity){
		HashMap<HashKey, ValueType*> hashMap(capacity, loadFactor_);
		int listSize = count_, listCounter = 0;
		HashKey* keyList = new HashKey[listSize];
		ValueType* valueList = new ValueType[listSize];
		for(int i = 0; i < capacity_; i++){
			HashItem<HashKey, ValueType>* item = &array_[i];
			if(item->value_ == NULL){ continue; }
			while(true){
				keyList[listCounter] = item->key_;
				valueList[listCounter] = item->value_;
				listCounter++;
				item = item->next_;
				if(item == NULL){ break; }
			}
		}
		clear();
		delete[] array_;
		capacity_ = capacity;
		maxSize_ = (int)(capacity_ * loadFactor_);
		array_ = new HashItem<HashKey, ValueType>[capacity_];
		// LpVeB̊gN\
		for(int i = 0;i < listSize;i++){ put(keyList[i], valueList[i]); }
		delete[] keyList;
		delete[] valueList;
	}

	/**
	 * g
	 */
	void trim(){
		int newCapacity = 1, maxSize;
		while(true){
			maxSize = (int)(newCapacity * loadFactor_);
			if(count_ <= maxSize){ break; }
			newCapacity *= 2;
		}
		setCapacity(newCapacity);
	}

	//--------------------------------------------------------------------------
#ifdef _DEBUG
	/**
	 * fobOpo
	 * @param detail ڍ׏o
	 */
	void debugPrint(bool detail){
		DebugOut("\nCapacity %d, LoadFactor %.2f MaxSize %d Size %d ",
			capacity_, loadFactor_, maxSize_, count_);
		if(detail){ DebugOut("\n"); }
		int allocCount = 0;
		for(int i = 0;i < capacity_;i++){
			HashItem<HashKey, ValueType>* item = &array_[i];
			int count = 0;
			// S\
			while(true){
				count++;
				if(count >= 2){ allocCount++; }
				if(detail){
					if(item->value_ != NULL){ DebugOut("*"); }
				}	
				if(item->next_ == NULL){ break; }
				item = item->next_;
			}
			if(detail){ DebugOut("\n"); }
		}
		DebugOut("allocCount %d allocRate %.1f%%\n",
			allocCount, (float)allocCount / count_ * 100.f);
	}
#endif

private:
	//--------------------------------------------------------------------------
	// nbVACe
	template <typename HashKey, typename ValueType>
	class HashItem{
	friend class HashMap;
	public:
		// ftHgRXgN^
		HashItem() : key_(), value_(NULL), next_(NULL){}

		// lLRXgN^
		HashItem(HashKey key, ValueType value) :
			key_(), value_(value), next_(NULL){
			key_ = key;// Rs[RXgN^̎`𖳂B
		}

		// Zq
		HashItem& operator =(const HashItem& copy){
			key_ = copy.key_;
			value_ = copy.value_;
			next_ = copy.next_;
			return *this;
		}

		// L[l
		HashKey key_;
		// l
		ValueType value_;
		// ̃ACe
		HashItem* next_;
	};

	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	HashMap(const HashMap& copy);

	// Rs[̉B
	void operator =(const HashMap& copy);

	//--------------------------------------------------------------------------
	// e
	int capacity_;
	// ׌W
	float loadFactor_;
	// őTCY
	int maxSize_;
	// TCY
	int count_;
	// nbVz
	HashItem<HashKey, ValueType>* array_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of HASH_MAP_H_
//------------------------------------------------------------------------------
