//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * fbNwb_
 * @author Junpee
 */

#ifndef DEQUE_H_
#define DEQUE_H_

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * fbN
 *
 * ̃NX͌pȂŉB
 */
template <typename Type>
class Deque{
public:
	//--------------------------------------------------------------------------
	// \zAj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	Deque(){
		capacity_ = defaultCapacity_;
		array_ = new Type[capacity_];
		front_ = count_ = 0;
	}

	/**
	 * RXgN^
	 * @param capacity LpVeBB2̗ݏ悪D܂B
	 */
	explicit Deque(int capacity){
		Assert(capacity > 0);
		capacity_ = capacity;
		array_ = new Type[capacity_];
		front_ = count_ = 0;
	}

	/**
	 * fXgN^
	 */
	~Deque(){ delete[] array_; }

	/**
	 * N[
	 * @param destination N[fbN
	 */
	void clone(Deque& destination) const{
		delete[] destination.array_;
		destination.capacity_ = capacity_;
		destination.array_ = new Type[capacity_];
		destination.front_ = front_;
		destination.count_ = count_;
		// NX𐳂Rs[ɂmemcpył͑ʖ
		for(int i = 0; i < count_; i++){
			int index = (i + front_) % capacity_;
			destination.array_[index] = array_[index];
		}
	}

	//--------------------------------------------------------------------------
	// ̎擾
	//--------------------------------------------------------------------------
	/**
	 * vf̎擾
	 * @return vf
	 */
	int getCount() const{ return count_; }

	/**
	 * 󂩂ǂ
	 * @return ȂtrueԂ
	 */
	bool isEmpty() const{ return (count_ == 0); }

	/**
	 * vf̎擾
	 * @param index 擾vf̃CfbNX
	 * @return vf
	 */
	Type& get(int index) const{
		Assert(index >= 0);
		Assert(index < count_);
		return array_[(front_ + index) % capacity_];
	}

	/**
	 * vf̎擾
	 * @param index 擾vf̃CfbNX
	 * @return vf
	 */
	Type& operator [](int index) const{
		Assert(index >= 0);
		Assert(index < count_);
		return array_[(front_ + index) % capacity_];
	}

	/**
	 * LpVeB̎擾
	 * @return LpVeB
	 */
	int getCapacity() const{ return capacity_; }

	/**
	 * O̒ľ
	 *
	 * fbN̑OlAł΂̃CfbNXԂ܂B
	 * @param searchValue l
	 * @return l̃CfbNXBl-1ԂB
	 */
	int indexOf(const Type& searchValue) const{
		for(int i = 0; i < count_; i++){
			if(array_[(front_ + i) % capacity_] == searchValue){ return i; }
		}
		return -1;
	}

	/**
	 * ォ̒ľ
	 *
	 * fbŇ납lAł΂̃CfbNXԂ܂B
	 * @param searchValue l
	 * @return l̃CfbNXBl-1ԂB
	 */
	int lastIndexOf(const Type& searchValue) const{
		for(int i = count_ - 1; i >= 0; i--){
			if(array_[(front_ + i) % capacity_] == searchValue){ return i; }
		}
		return -1;
	}

	//--------------------------------------------------------------------------
	// fbN̕ύX
	//--------------------------------------------------------------------------
	/**
	 * 擪ւ̗vf̒ǉ
	 * @param value vf
	 */
	void pushFront(const Type& value){
		if((count_ + 1) > capacity_){ resize(capacity_ * 2); }
		front_--;
		if(front_ < 0){ front_ += capacity_; }
		array_[front_] = value;
		count_++;
	}

	/**
	 * ւ̗vf̒ǉ
	 * @param value vf
	 */
	void pushBack(const Type& value){
		if((count_ + 1) > capacity_){ resize(capacity_ * 2); }
		array_[(front_ + count_) % capacity_] = value;
		count_++;
	}

	/**
	 * 擪̗vf̍폜
	 * @return 폜vf
	 */
	Type popFront(){
		Assert(count_ > 0);
		int resultIndex = front_;
		front_ = (front_ + 1) % capacity_;
		count_--;
		return array_[resultIndex];
	}

	/**
	 * ̗vf̍폜
	 * @return 폜vf
	 */
	Type popBack(){
		Assert(count_ > 0);
		int resultIndex = (front_ + count_ - 1) % capacity_;
		count_--;
		return array_[resultIndex];
	}

	/**
	 * vf̐ݒ
	 * @param index vfݒ肷CfbNX
	 * @param value vf
	 */
	void set(int index, const Type& value) const{
		Assert(index >= 0);
		Assert(index < count_);
		array_[(front_ + index) % capacity_] = value;
	}

	/**
	 * vf̍폜
	 * @param index 폜vf̃CfbNX
	 * @return fbN폜vf
	 */
	Type remove(int index){
		Assert(index >= 0);
		Assert(index < count_);
		Assert(count_ > 0);
		Type result = array_[(front_ + index) % capacity_];
		count_--;
		if(index < (count_ / 2)){
			// Ol߂
			for(int i = index - 1; i >= 0; i--){
				int source = (front_ + i) % capacity_;
				int destination = (source + 1) % capacity_;
				array_[destination] = array_[source];
			}
			// OCfbNX炷
			front_ = (front_ + 1) % capacity_;
		}else{
			// l߂
			for(int i = index; i < count_; i++){
				int destination = (front_ + i) % capacity_;
				int source = (destination + 1) % capacity_;
				array_[destination] = array_[source];
			}
		}
		return result;
	}

	/**
	 * lɂvf̍폜
	 *
	 * fbŇ납폜lAvf΍폜܂B
	 * @param removeValue 폜vf̒l
	 * @return 폜CfbNXB-1ȂYvfB
	 */
	int removeByValue(const Type& removeValue){
		int index = lastIndexOf(removeValue);
		if(index == -1){ return index; }
		remove(index);
		return index;
	}

	/**
	 * Svf폜
	 */
	void clear(){ front_ = count_ = 0; }

	/**
	 * Svf폜
	 * @param capacity NÃLpVeB
	 */
	void clear(int capacity){
		Assert(capacity >= 0);
		if(capacity <= 0){ capacity = 1; }
		delete[] array_;
		capacity_ = capacity;
		array_ = new Type[capacity_];
		front_ = count_ = 0;
	}

	/**
	 * LpVeB̐ݒ
	 * @param newCapacity VLpVeB
	 */
	void setCapacity(int newCapacity){
		Assert(newCapacity >= count_);
		resize(newCapacity);
	}

	/**
	 * g
	 *
	 * ݂̃TCYɍ킹Ďgpŏɂ܂B
	 */
	void trim(){
		if(count_ == 0){ resize(1);}
		else{ resize(count_); }
	}

	//--------------------------------------------------------------------------
	// \[gƃT[`
	//--------------------------------------------------------------------------
	/**
	 * \[g
	 *
	 * NCbN\[gŃfbN\[g܂B<br>
	 * compare̕Ԃlȉ̂悤ɂƏɃ\[g܂B<br>
	 * 傫Ƃ1ȏ<br>
	 * ƑɈꍇ0<br>
	 * 菬Ƃ-1ȉ
	 * @param compare r֐B
	 */
	void sort( int(*compare)(const Type*, const Type*) ){
		// ɂ
		if((front_ + count_) > capacity_){
			if(count_ != capacity_){
				// Ԃl߂
				int destination = (front_ + count_) % capacity_;
				for(int i = front_; i < capacity_; i++, destination++){
					array_[destination] = array_[i];
				}

			}
			front_ = 0;
		}
		qsort(array_ + front_, count_, sizeof(Type),
			(int(*)(const void*, const void*))compare);
	}

	/**
	 * T[`
	 *
	 * oCiT[`ŃfbN܂B<br>
	 * fbN͏Ƀ\[gĂKv܂B<br>
	 * vfȂꍇNULLԂ܂B
	 * compare͈ȉ̂悤ȕԂlԂĂB<br>
	 * 傫Ƃ1ȏ<br>
	 * ƑɈꍇ0<br>
	 * 菬Ƃ-1ȉ
	 * @param key l
	 * @param compare r֐
	 * @return ʁAȂNULL
	 */
	Type* search(Type key, int(*compare)(const Type*, const Type*) ){
		return (Type*)bsearch(&key, array_ + front_, count_, sizeof(Type),
			(int(*)(const void*, const void*))compare);
	}

private:
	// TCY
	void resize(int newCapacity){
		Assert(newCapacity > 0);
		Type* newArray = new Type[newCapacity];
		// NX𐳂Rs[ɂmemcpył͑ʖ
		for(int i = 0; i < count_; i++){
			int index = i + front_;
			int source = index % capacity_;
			int destination = index % newCapacity;
			newArray[destination] = array_[source];
		}
		delete[] array_;
		array_ = newArray;
		capacity_ = newCapacity;
	}

	// Rs[RXgN^̉B
	Deque(const Deque& copy);

	// Rs[̉B
	void operator =(const Deque& copy);

	// z
	Type* array_;
	// OCfbNX
	int front_;
	// vf
	int count_;
	// LpVeB
	int capacity_;
	// ftHgLpVeB
	static const int defaultCapacity_ = 16;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of DEQUE_H_
//------------------------------------------------------------------------------
