//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ACXgwb_
 * @author Junpee
 */

#ifndef ARRAY_LIST_H_
#define ARRAY_LIST_H_

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * ACXg
 *
 * ̃NX͌pȂŉB
 */
template <typename Type>
class ArrayList{
public:
	//--------------------------------------------------------------------------
	// \zAj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	ArrayList(){
		capacity_ = defaultCapacity_;
		array_ = new Type[capacity_];
		count_ = 0;
	}

	/**
	 * RXgN^
	 * @param capacity LpVeBB2̗ݏ悪D܂B
	 */
	explicit ArrayList(int capacity){
		Assert(capacity > 0);
		capacity_ = capacity;
		array_ = new Type[capacity_];
		count_ = 0;
	}

	/**
	 * fXgN^
	 */
	~ArrayList(){ delete[] array_; }

	/**
	 * N[
	 * @param destination N[ACXg
	 */
	void clone(ArrayList& destination) const{
		delete[] destination.array_;
		destination.capacity_ = capacity_;
		destination.array_ = new Type[capacity_];
		// NX𐳂Rs[ɂmemcpył͑ʖ
		for(int i = 0; i < count_; i++){ destination.array_[i] = array_[i]; }
		destination.count_ = count_;
	}

	//--------------------------------------------------------------------------
	// ̎擾
	//--------------------------------------------------------------------------
	/**
	 * vf̎擾
	 * @return vf
	 */
	int getCount() const{ return count_; }

	/**
	 * 󂩂ǂ
	 * @return ȂtrueԂ
	 */
	bool isEmpty() const{ return (count_ == 0); }

	/**
	 * vf̎擾
	 * @param index 擾vf̃CfbNX
	 * @return vf
	 */
	Type& get(int index) const{
		Assert(index >= 0);
		Assert(index < count_);
		return array_[index];
	}

	/**
	 * vf̎擾
	 * @param index 擾vf̃CfbNX
	 * @return vf
	 */
	Type& operator [](int index) const{
		Assert(index >= 0);
		Assert(index < count_);
		return array_[index];
	}

	/**
	 * LpVeB̎擾
	 * @return LpVeB
	 */
	int getCapacity() const{ return capacity_; }

	/**
	 * ľ
	 *
	 * ACXg̑OlAł΂̃CfbNXԂ܂B
	 * @param searchValue l
	 * @return l̃CfbNXBl-1ԂB
	 */
	int indexOf(const Type& searchValue) const{
		for(int i = 0; i < count_; i++){
			if(array_[i] == searchValue){ return i; }
		}
		return -1;
	}

	/**
	 * 납̒ľ
	 *
	 * ACXǧ납lAł΂̃CfbNXԂ܂B
	 * @param searchValue l
	 * @return l̃CfbNXBl-1ԂB
	 */
	int lastIndexOf(const Type& searchValue) const{
		for(int i = count_ - 1; i >= 0; i--){
			if(array_[i] == searchValue){ return i; }
		}
		return -1;
	}

	//--------------------------------------------------------------------------
	// ACXg̕ύX
	//--------------------------------------------------------------------------
	/**
	 * vf̒ǉ
	 * @param value vf
	 */
	void add(const Type& value){
		if((count_ + 1) > capacity_){ resize(capacity_ * 2); }
		array_[count_] = value;
		count_++;
	}

	/**
	 * vf̐ݒ
	 * @param index vfݒ肷CfbNX
	 * @param value vf
	 * @return vf
	 */
	void set(int index, const Type& value) const{
		Assert(index >= 0);
		Assert(index < count_);
		array_[index] = value;
	}

	/**
	 * vf̍폜
	 * @param index 폜vf̃CfbNX
	 * @return ACXg폜vf
	 */
	Type remove(int index){
		Assert(index >= 0);
		Assert(index < count_);
		Assert(count_ > 0);
		Type result = array_[index];
		count_--;
		for(int i = index; i < count_; i++){ array_[i] = array_[i + 1]; }
		return result;
	}

	/**
	 * lɂvf̍폜
	 *
	 * ACXǧ납폜lAvf΍폜܂B
	 * @param removeValue 폜vf̒l
	 * @return 폜CfbNXB-1ȂYvfB
	 */
	int removeByValue(const Type& removeValue){
		for(int i = count_ - 1; i >= 0; i--){
			if(array_[i] == removeValue){
				remove(i);
				return i;
			}
		}
		return -1;
	}

	/**
	 * Svf폜
	 */
	void clear(){ count_ = 0; }

	/**
	 * Svf폜
	 * @param capacity NÃLpVeB
	 */
	void clear(int capacity){
		Assert(capacity >= 0);
		if(capacity <= 0){ capacity = 1; }
		delete[] array_;
		capacity_ = capacity;
		array_ = new Type[capacity_];
		count_ = 0;
	}

	/**
	 * LpVeB̐ݒ
	 * @param newCapacity VLpVeB
	 */
	void setCapacity(int newCapacity){
		Assert(newCapacity >= count_);
		resize(newCapacity);
	}

	/**
	 * g
	 *
	 * ݂̃TCYɍ킹Ďgpŏɂ܂B
	 */
	void trim(){
		if(count_ == 0){ resize(1);}
		else{ resize(count_); }
	}

	//--------------------------------------------------------------------------
	// \[gƃT[`
	//--------------------------------------------------------------------------
	/**
	 * \[g
	 *
	 * NCbN\[gŃACXg\[g܂B<br>
	 * compare̕Ԃlȉ̂悤ɂƏɃ\[g܂B<br>
	 * 傫Ƃ1ȏ<br>
	 * ƑɈꍇ0<br>
	 * 菬Ƃ-1ȉ
	 * @param compare r֐B
	 */
	void sort( int(*compare)(const Type*, const Type*) ){
		qsort(array_, count_, sizeof(Type),
			(int(*)(const void*, const void*))compare);
	}

	/**
	 * T[`
	 *
	 * oCiT[`ŃACXg܂B<br>
	 * ACXg͏Ƀ\[gĂKv܂B<br>
	 * vfȂꍇNULLԂ܂B
	 * compare͈ȉ̂悤ȕԂlԂĂB<br>
	 * 傫Ƃ1ȏ<br>
	 * ƑɈꍇ0<br>
	 * 菬Ƃ-1ȉ
	 * @param key l
	 * @param compare r֐
	 * @return ʁAȂNULL
	 */
	Type* search(Type key, int(*compare)(const Type*, const Type*) ){
		return (Type*)bsearch(&key, array_, count_, sizeof(Type),
			(int(*)(const void*, const void*))compare);
	}

private:
	// TCY
	void resize(int newCapacity){
		Assert(newCapacity > 0);
		Assert(newCapacity >= count_);
		Type* newArray = new Type[newCapacity];
		// NX𐳂Rs[ɂmemcpył͑ʖ
		for(int i = 0; i < count_; i++){ newArray[i] = array_[i]; }
		delete[] array_;
		array_ = newArray;
		capacity_ = newCapacity;
	}

	// Rs[RXgN^̉B
	ArrayList(const ArrayList& copy);

	// Rs[̉B
	void operator =(const ArrayList& copy);

	// AC{
	Type* array_;
	// TCY
	int count_;
	// LpVeB
	int capacity_;
	// ftHgLpVeB
	static const int defaultCapacity_ = 16;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of ARRAY_LIST_H_
//------------------------------------------------------------------------------
