//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * TargaZ[owb_
 * @author Junpee
 */

#ifndef TARGA_SAVER_H_
#define TARGA_SAVER_H_

namespace Lamp{

class BinaryWriter;

//------------------------------------------------------------------------------
/**
 * TargaZ[o
 *
 * pbgĂȂ񈳏kTargaZ[o
 */
class TargaSaver{
public:
	/**
	 * RXgN^
	 */
	TargaSaver();

	/**
	 * fXgN^
	 */
	virtual ~TargaSaver();

	/**
	 * Z[u
	 * @param writer oCiC^
	 * @param size TCY
	 * @param colors oFz
	 */
	virtual void save(BinaryWriter* writer,
		const DimensionI& size, const Color3c* colors);

	/**
	 * Z[u
	 * @param writer oCiC^
	 * @param size TCY
	 * @param colors oFz
	 */
	virtual void save(BinaryWriter* writer,
		const DimensionI& size, const Color4c* colors);

	/**
	 * Z[u
	 * @param writer oCiC^
	 * @param width 
	 * @param height 
	 * @param colors oFz
	 */
	virtual void save(BinaryWriter* writer,
		int width, int height, const Color3c* colors);

	/**
	 * Z[u
	 * @param writer oCiC^
	 * @param width 
	 * @param height 
	 * @param colors oFz
	 */
	virtual void save(BinaryWriter* writer,
		int width, int height, const Color4c* colors);

	/**
	 * Z[u
	 * @param filePath t@CpX
	 * @param size TCY
	 * @param colors oFz
	 */
	virtual void save(const String& filePath,
		const DimensionI& size, const Color3c* colors);

	/**
	 * Z[u
	 * @param filePath t@CpX
	 * @param size TCY
	 * @param colors oFz
	 */
	virtual void save(const String& filePath,
		const DimensionI& size, const Color4c* colors);

	/**
	 * Z[u
	 * @param filePath t@CpX
	 * @param width 
	 * @param height 
	 * @param colors oFz
	 */
	virtual void save(const String& filePath,
		int width, int height, const Color3c* colors);

	/**
	 * Z[u
	 * @param filePath t@CpX
	 * @param width 
	 * @param height 
	 * @param colors oFz
	 */
	virtual void save(const String& filePath,
		int width, int height, const Color4c* colors);

protected:
	/**
	 * wb_̏o
	 * @param hasAlpha At@Ȃtrue
	 */
	virtual void writeHeader(bool hasAlpha);

	/**
	 * tb^̏o
	 */
	virtual void writeFooter();

private:
	// Rs[RXgN^̉B
	TargaSaver(const TargaSaver& copy);

	// Rs[̉B
	void operator =(const TargaSaver& copy);

	// oCiC^
	BinaryWriter* writer_;
	// TCY
	DimensionI size_;

	// tb^
	static const char footer_[];
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of TARGA_SAVER_H_
//------------------------------------------------------------------------------

