//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Targa[_wb_
 * @author Junpee
 */

#ifndef TARGA_LOADER_H_
#define TARGA_LOADER_H_

namespace Lamp{

class BinaryReader;

//------------------------------------------------------------------------------
/**
 * Targa[_
 *
 * pbgĂȂ񈳏kTarga[_
 */
class TargaLoader{
public:
	/**
	 * RXgN^
	 * @param reader [_
	 */
	TargaLoader(BinaryReader* reader);

	/**
	 * RXgN^
	 * @param fileName t@C
	 */
	TargaLoader(const String& fileName);

	/**
	 * fXgN^
	 */
	virtual ~TargaLoader();

	/**
	 * wb_̃[h
	 * @return true
	 */
	virtual bool loadHeader();

	//--------------------------------------------------------------------------
	/**
	 * TCY̎擾
	 * @return TCY
	 */
	virtual DimensionI getSize() const{ return size_; }

	/**
	 * ̎擾
	 * @return 
	 */
	virtual int getWidth() const{ return size_.width; }

	/**
	 * ̎擾
	 * @return 
	 */
	virtual int getHeight() const{ return size_.height; }

	/**
	 * At@ǂ
	 * @return At@Ȃtrue
	 */
	virtual int hasAlpha() const{ return hasAlpha_; }

	//--------------------------------------------------------------------------
	/**
	 * At@C[W̃[h
	 * @param output o͐obt@A(width * height) ̃J[zւ̃|C^
	 */
	virtual void loadImage(Color3c* output);

	/**
	 * At@LC[W̃[h
	 * @param output o͐obt@A(width * height) ̃J[zւ̃|C^
	 */
	virtual void loadImage(Color4c* output);

	//--------------------------------------------------------------------------
private:
	// Rs[RXgN^̉B
	TargaLoader(const TargaLoader& copy);

	// Rs[̉B
	void operator =(const TargaLoader& copy);

	// oCi[_
	BinaryReader* reader_;
	// TCY
	DimensionI size_;
	// At@
	bool hasAlpha_;
	// [_AP[g
	bool allocateReader_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of TARGA_LOADER_H_
//------------------------------------------------------------------------------

