//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * `ktB^wb_
 * @author Junpee
 */

#ifndef LINEAR_MINIFICATION_FILTER_H_
#define LINEAR_MINIFICATION_FILTER_H_

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * `ktB^
 */
class LinearMinificationFilter{
public:
	/**
	 * ̃TCY擾
	 * @param nowSize ݂̃TCY
	 * @return ̃TCY
	 */
	static DimensionI getNextSize(const DimensionI& nowSize){
		Assert((nowSize.width != 0) && (nowSize.height != 0));
		Assert((nowSize.width != 1) || (nowSize.height != 1));
		DimensionI result(nowSize.width / 2, nowSize.height / 2);
		if(result.width == 0){ result.width = 1; }
		if(result.height == 0){ result.height = 1; }
		return result;
	}

	/**
	 * tB^
	 * @param source \[XC[W
	 * @param sourceSize \[XC[WTCY
	 * @param destination fXeBl[VC[W
	 * @param destinationSize fXeBl[VC[WTCY
	 */
	static void filter(
		const Color3c* source, const DimensionI& sourceSize,
		Color3c* destination, const DimensionI destinationSize);

	/**
	 * tB^
	 * @param source \[XC[W
	 * @param sourceSize \[XC[WTCY
	 * @param destination fXeBl[VC[W
	 * @param destinationSize fXeBl[VC[WTCY
	 */
	static void filter(
		const Color4c* source, const DimensionI& sourceSize,
		Color4c* destination, const DimensionI destinationSize);

private:
	// RXgN^̉B
	LinearMinificationFilter();

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of LINEAR_MINIFICATION_FILTER_H_
//------------------------------------------------------------------------------

