//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ÓIOwb_
 * @author Junpee
 */

#ifndef STATIC_NAME_H_
#define STATIC_NAME_H_

#include <Core/Primitive/String.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * ÓIO
 */
class StaticName{
public:
	/**
	 * RXgN^
	 * @param name 閼O
	 */
	StaticName(const String& name) : name_(name){}

	/**
	 * fXgN^
	 */
	virtual ~StaticName(){}

	//--------------------------------------------------------------------------
	/**
	 * O̎擾
	 * @return O
	 */
	virtual const String& getName() const{ return name_; }

	/**
	 * O̎擾
	 * @return O
	 */
	virtual String getName(){ return name_; }

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	StaticName(const StaticName& copy);

	// Rs[̉B
	void operator =(const StaticName& copy);

	//--------------------------------------------------------------------------
	// O
	String name_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of STATIC_NAME_H_
//------------------------------------------------------------------------------
