//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * QƕtÓIOwb_
 * @author Junpee
 */

#ifndef REFERENCED_STATIC_NAME_H_
#define REFERENCED_STATIC_NAME_H_

#include <Core/BasicObject/StaticName.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * QƕtÓIO
 */
class ReferencedStaticName : public StaticName{
public:
	/**
	 * RXgN^
	 * @param name 閼O
	 */
	ReferencedStaticName(const String& name) :
		StaticName(name), referenceCount_(0){}

	/**
	 * fXgN^
	 */
	virtual ~ReferencedStaticName(){ Assert(referenceCount_ == 0); }

	//--------------------------------------------------------------------------
	/**
	 * QƂ̒ǉ
	 * @return QƃJEg
	 */
	virtual int addReference(){
		referenceCount_++;
		return referenceCount_;
	}

	/**
	 * QƂ̍폜
	 * @return QƃJEg
	 */
	virtual int removeReference(){
		referenceCount_--;
		Assert(referenceCount_ >= 0);
		return referenceCount_;
	}

	/**
	 * QƃJEg̎擾
	 */
	virtual int getReferenceCount() const{ return referenceCount_; }

private:
	//--------------------------------------------------------------------------
	// QƃJEg
	int referenceCount_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of REFERENCED_STATIC_NAME_H_
//------------------------------------------------------------------------------
