//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * RWV[wb_
 * @author Junpee
 */

#ifndef COLLISION_SCENE_H_
#define COLLISION_SCENE_H_

#include <Core/Renamer/Renamer.h>
#include <Core/Container/HashMap.h>
#include <Core/Container/ArrayList.h>

namespace Lamp{

class IntersectionResult;
class CollisionObject;
class CollisionNode;
class CollisionLeaf;
class StaticSphereCollision;
class StaticDeformedMeshCollision;

//------------------------------------------------------------------------------
/**
 * RWV[
 */
class CollisionScene{
public:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	CollisionScene();

	/**
	 * fXgN^
	 */
	virtual ~CollisionScene();

	//--------------------------------------------------------------------------
	// V[֘A
	//--------------------------------------------------------------------------
	/**
	 * 
	 */
	virtual void traverse();

	/**
	 * [gm[h̎擾
	 * @return [gm[h
	 */
	virtual CollisionNode* getRootNode(){ return rootNode_; }

	//--------------------------------------------------------------------------
	/**
	 * `bN̐ݒ
	 * @param tick `bN
	 */
	virtual void setTick(int tick){ tick_ = tick; }

	/**
	 * `bN̎擾
	 * @return `bN
	 */
	virtual int getTick() const{ return tick_; }

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param result 
	 * @param sphere 
	 * @param collisionMask RW}XN
	 */
	virtual void intersection(IntersectionResult* result, const Sphere& sphere,
		u_int collisionMask = 0xffffffff);

	/**
	 * RW
	 * @param result 
	 * @param sphere RW
	 * @param collisionMask RW}XN
	 */
	virtual void intersection(IntersectionResult* result,
		StaticSphereCollision* sphere, u_int collisionMask = 0xffffffff);

	//--------------------------------------------------------------------------
	// Փ
	//--------------------------------------------------------------------------

	//--------------------------------------------------------------------------
	// RWm[h
	//--------------------------------------------------------------------------
	/**
	 * RWm[h̍쐬
	 *
	 * łɓÕRWIuWFNg݂ƃG[ɂȂ܂B
	 * 󕶎𖼑OɎw肷ƃG[ɂȂ܂B
	 * @param name O
	 * @return RWm[h
	 */
	CollisionNode* createCollisionNode(const String& name);

	//--------------------------------------------------------------------------
	// ÓIRW[t
	//--------------------------------------------------------------------------
	/**
	 * ÓIRW̍쐬
	 *
	 * łɓÕRWIuWFNg݂ƃG[ɂȂ܂B
	 * 󕶎𖼑OɎw肷ƃG[ɂȂ܂B
	 * @param name O
	 * @return ÓIRW
	 */
	StaticSphereCollision* createStaticSphereCollision(const String& name);

	//--------------------------------------------------------------------------
	/**
	 * ÓIό`bVRW̍쐬
	 *
	 * łɓÕRWIuWFNg݂ƃG[ɂȂ܂B
	 * 󕶎𖼑OɎw肷ƃG[ɂȂ܂B
	 * @param name O
	 * @return ÓIό`bVRW
	 */
	StaticDeformedMeshCollision* createStaticDeformedMeshCollision(
		const String& name);

	//--------------------------------------------------------------------------
	// RWIuWFNgj
	//--------------------------------------------------------------------------
	/**
	 * m[hIuWFNg̔j
	 * @param node jm[hIuWFNg
	 */
	virtual void destroyNode(CollisionNode* node);

	/**
	 * [tIuWFNg̔j
	 * @param leaf j郊[tIuWFNg
	 */
	virtual void destroyLeaf(CollisionLeaf* leaf);

	/**
	 * NA
	 * @return 폜RWIuWFNg
	 */
	virtual int clear();

	//--------------------------------------------------------------------------
	// RWIuWFNg̑
	//--------------------------------------------------------------------------
	/**
	 * m[hIuWFNg̎擾
	 * @return m[hIuWFNg
	 */
	virtual int getNodeCount(){ return nodeArray_.getCount(); }

	/**
	 * m[hIuWFNg̎擾
	 * @param index m[hIuWFNg̃CfNX
	 * @return m[hIuWFNg
	 */
	virtual CollisionNode* getNode(int index){ return nodeArray_.get(index); }

	/**
	 * m[hIuWFNǧ
	 * @param name m[hIuWFNg
	 * @return m[hIuWFNg
	 */
	virtual CollisionNode* searchNode(const String& name){
		return nodeDatabase_.get(name);
	}

	/**
	 * m[h݂邩ǂ
	 * @param name ݂邩ǂׂ閼O
	 * @return m[h݂true
	 */
	virtual bool existNodeName(const String& name){
		return (searchNode(name) != NULL);
	}

	//--------------------------------------------------------------------------
	/**
	 * [tIuWFNg̎擾
	 * @return [tIuWFNg
	 */
	virtual int getLeafCount(){ return leafArray_.getCount(); }

	/**
	 * [tIuWFNg̎擾
	 * @param index [tIuWFNg̃CfNX
	 * @return [tIuWFNg
	 */
	virtual CollisionLeaf* getLeaf(int index){ return leafArray_.get(index); }

	/**
	 * [tIuWFNǧ
	 * @param name 郊[tIuWFNg
	 * @return [tIuWFNg
	 */
	virtual CollisionLeaf* searchLeaf(const String& name){
		return leafDatabase_.get(name);
	}

	/**
	 * [t݂邩ǂ
	 * @param name ݂邩ǂׂ閼O
	 * @return [t݂true
	 */
	virtual bool existLeafName(const String& name){
		return (searchLeaf(name) != NULL);
	}

	//--------------------------------------------------------------------------
	// l[֌W
	//--------------------------------------------------------------------------
	/**
	 * m[h̃l[
	 * @param name ƂȂ閼O
	 * @return dĂȂO
	 */
	virtual String renameNode(const String& name){
		return nodeRenamer_->rename(&nodeRenamerCallback_, name);
	}

	/**
	 * m[hl[}̐ݒ
	 * @param renamer ݒ肷m[hl[}
	 */
	virtual void setNodeRenamer(Renamer* renamer){
		Assert((renamer != NULL) && (nodeRenamer_ != NULL));
		SafeDelete(nodeRenamer_);
		nodeRenamer_ = renamer;
	}

	//--------------------------------------------------------------------------
	/**
	 * [t̃l[
	 * @param name ƂȂ閼O
	 * @return dĂȂO
	 */
	virtual String renameLeaf(const String& name){
		return leafRenamer_->rename(&leafRenamerCallback_, name);
	}

	/**
	 * [tl[}̐ݒ
	 * @param renamer ݒ肷郊[tl[}
	 */
	virtual void setLeafRenamer(Renamer* renamer){
		Assert((renamer != NULL) && (leafRenamer_ != NULL));
		SafeDelete(leafRenamer_);
		leafRenamer_ = renamer;
	}

protected:
	//--------------------------------------------------------------------------
	// l[}
	//--------------------------------------------------------------------------
	/// m[hl[}R[obN
	class NodeRenamerCallback : public Renamer::Database{
		friend class CollisionScene;
	private:
		/**
		 * O݂邩ǂ
		 * @param name ݂邩ǂׂ閼O
		 * @return O݂true
		 */
		virtual bool existName(const String& name){
			return scene_->existNodeName(name);
		}

		// V[
		CollisionScene* scene_;
	};

	//--------------------------------------------------------------------------
	/// [tl[}R[obN
	class LeafRenamerCallback : public Renamer::Database{
		friend class CollisionScene;
	private:
		/**
		 * O݂邩ǂ
		 * @param name ݂邩ǂׂ閼O
		 * @return O݂true
		 */
		virtual bool existName(const String& name){
			return scene_->existLeafName(name);
		}

		// V[
		CollisionScene* scene_;
	};

	//--------------------------------------------------------------------------
	// [eBeB
	//--------------------------------------------------------------------------
	/**
	 * [t̖O`FbN
	 * @param name `FbN閼O
	 * @return ȖOȂtrueԂ
	 */
	bool checkLeafName(const String& name);

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	CollisionScene(const CollisionScene& copy);

	// Rs[̉B
	void operator =(const CollisionScene& copy);

	//--------------------------------------------------------------------------
	// m[hf[^x[X
	HashMap<String, CollisionNode*> nodeDatabase_;
	// m[hz
	ArrayList<CollisionNode*> nodeArray_;
	// m[hl[}
	Renamer* nodeRenamer_;
	// m[hl[}R[obN
	NodeRenamerCallback nodeRenamerCallback_;
	// [tf[^x[X
	HashMap<String, CollisionLeaf*> leafDatabase_;
	// [tz
	ArrayList<CollisionLeaf*> leafArray_;
	// [tl[}
	Renamer* leafRenamer_;
	// [tl[}R[obN
	LeafRenamerCallback leafRenamerCallback_;
	// [gm[h
	CollisionNode* rootNode_;
	// `bN
	int tick_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of COLLISION_SCENE_H_
//------------------------------------------------------------------------------
