//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * RWIuWFNgwb_
 * @author Junpee
 */

#ifndef COLLISION_OBJECT_H_
#define COLLISION_OBJECT_H_

namespace Lamp{

class CollisionScene;
class CollisionNode;
class CollisionLeaf;
class StaticCollisionLeaf;
class StaticSphereCollision;
class StaticDeformedMeshCollision;
class DynamicCollisionLeaf;

//------------------------------------------------------------------------------
/**
 * RWIuWFNg
 */
class CollisionObject{
friend class CollisionScene;
friend class CollisionNode;
public:
	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * 
	 */
	virtual void traverse();

	//--------------------------------------------------------------------------
	// oANZT
	//--------------------------------------------------------------------------
	/**
	 * O̎擾
	 * @return O
	 */
	virtual const String& getName() const{ return name_; }

	//--------------------------------------------------------------------------
	/**
	 * V[̎擾
	 * @return V[
	 */
	virtual CollisionScene* getScene() const{ return scene_; }

	//--------------------------------------------------------------------------
	/**
	 * e̎擾
	 * @return e
	 */
	virtual CollisionNode* getParent() const{ return parent_; }

	//--------------------------------------------------------------------------
	// LA
	//--------------------------------------------------------------------------
	/**
	 * LA̐ݒ
	 * @param enabled trueȂLAfalseȂ疳
	 */
	virtual void setEnabled(bool enabled){
		enabled_ = enabled;
		setChanged(true);
	}

	/**
	 * LA̎擾
	 * @return trueȂLAfalseȂ疳
	 */
	virtual bool isEnabled() const{ return enabled_; }

	/**
	 * O[oł̗LA̎擾
	 * @return trueȂLAfalseȂ疳
	 */
	virtual bool isGlobalEnabled() const{ return globalEnabled_; }

	//--------------------------------------------------------------------------
	// [Uf[^
	//--------------------------------------------------------------------------
	/**
	 * [Uf[^̐ݒ
	 * @param userData [Uf[^
	 */
	virtual void setUserData(void* userData){ userData_ = userData; }

	/**
	 * [Uf[^̎擾
	 * @return [Uf[^
	 */
	virtual void* getUserData(){ return userData_; }

	//--------------------------------------------------------------------------
	// ύXtO
	//--------------------------------------------------------------------------
	/**
	 * O[oł̕ύXtO̎擾
	 * @return O[oŕύXĂtrue
	 */
	virtual bool isGlobalChanged() const{ return globalChanged_; }

	//--------------------------------------------------------------------------
	// Rs[
	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @return Rs[ꂽRWIuWFNg
	 */
	virtual CollisionObject* copy() const = 0;

	/**
	 * ċAIj
	 * @param collisionObject jRWIuWFNg
	 * @return jIuWFNg
	 */
	static int recursiveDestroy(CollisionObject* collisionObject);

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * RWm[hǂ
	 * @return RWm[hȂtrue
	 */
	virtual bool isCollisionNode() const{ return false; }

	/**
	 * RWm[hւ̃LXg
	 * @return RWm[hB^ႦNULLԂB
	 */
	virtual CollisionNode* castCollisionNode() const{
		if(isCollisionNode()){ return (CollisionNode*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * RW[tǂ
	 * @return RW[tȂtrue
	 */
	virtual bool isCollisionLeaf() const{ return false; }

	/**
	 * RW[tւ̃LXg
	 * @return RW[tB^ႦNULLԂB
	 */
	virtual CollisionLeaf* castCollisionLeaf() const{
		if(isCollisionLeaf()){ return (CollisionLeaf*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	// ÓIRW[tRTTI
	//--------------------------------------------------------------------------
	/**
	 * ÓIRW[tǂ
	 * @return ÓIRW[tȂtrue
	 */
	virtual bool isStaticCollisionLeaf() const{ return false; }

	/**
	 * ÓIRW[tւ̃LXg
	 * @return ÓIRW[tB^ႦNULLԂB
	 */
	virtual StaticCollisionLeaf* castStaticCollisionLeaf() const{
		if(isStaticCollisionLeaf()){ return (StaticCollisionLeaf*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * ÓIRWǂ
	 * @return ÓIRWȂtrue
	 */
	virtual bool isStaticSphereCollision() const{ return false; }

	/**
	 * ÓIRWւ̃LXg
	 * @return ÓIRWB^ႦNULLԂB
	 */
	virtual StaticSphereCollision* castStaticSphereCollision() const{
		if(isStaticSphereCollision()){ return (StaticSphereCollision*)this; }
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * ÓIό`bVRWǂ
	 * @return ÓIό`bVRWȂtrue
	 */
	virtual bool isStaticDeformedMeshCollision() const{ return false; }

	/**
	 * ÓIό`bVRWւ̃LXg
	 * @return ÓIό`bVRWB^ႦNULLԂB
	 */
	virtual StaticDeformedMeshCollision*
		castStaticDeformedMeshCollision() const{
		if(isStaticDeformedMeshCollision()){
			return (StaticDeformedMeshCollision*)this;
		}
		return NULL;
	}

	//--------------------------------------------------------------------------
	// IRW[tRTTI
	//--------------------------------------------------------------------------
	/**
	 * IRW[tǂ
	 * @return IRW[tȂtrue
	 */
	virtual bool isDynamicCollisionLeaf() const{ return false; }

	/**
	 * IRW[tւ̃LXg
	 * @return IRW[tB^ႦNULLԂB
	 */
	virtual DynamicCollisionLeaf* castDynamicCollisionLeaf() const{
		if(isDynamicCollisionLeaf()){ return (DynamicCollisionLeaf*)this; }
		return NULL;
	}

protected:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	CollisionObject(const String& name, CollisionScene* scene) :
		name_(name), scene_(scene), parent_(NULL), userData_(NULL),
		enabled_(true), changed_(true), globalChanged_(true){
		// globalEnabled_̏lNodeLeafňႤ
	}

	/**
	 * fXgN^
	 */
	virtual ~CollisionObject(){}

	//--------------------------------------------------------------------------
	// Rs[
	//--------------------------------------------------------------------------
	/**
	 * RWIuWFNg̒lRs[
	 * @param destination Rs[RWIuWFNg
	 */
	virtual void copyCollisionObjectValue(CollisionObject* destination) const{
		destination->enabled_ = enabled_;
		Assert(destination->changed_);
	}

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param parentMatrix es
	 * @param parentEnabled eL
	 * @param parentScaled eXP[gpĂ邩
	 * @param parentChanged eɕύX
	 */
	// Ȃtraverse()ƃI[o[[hȂApublictraverseB
	virtual void traverseImplement(const Matrix34& parentMatrix,
		bool parentEnabled, bool parentScaled, bool parentChanged) = 0;

	//--------------------------------------------------------------------------
	// LA
	//--------------------------------------------------------------------------
	/**
	 * O[oł̗LA̐ݒ
	 * @param globalEnabled trueȂLAfalseȂ疳
	 */
	virtual void setGlobalEnabled(bool globalEnabled){
		globalEnabled_ = globalEnabled;
	}

	//--------------------------------------------------------------------------
	// ύXtO
	//--------------------------------------------------------------------------
	/**
	 * ύXtO̎擾
	 * @return ύXĂtrue
	 */
	virtual bool isChanged() const{ return changed_; }

	/**
	 * ύXtO̐ݒ
	 * @param changed trueȂLAfalseȂ疳
	 */
	virtual void setChanged(bool changed){ changed_ = changed; }

	/**
	 * O[oł̕ύXtO̐ݒ
	 * @param globalChanged trueȂLAfalseȂ疳
	 */
	virtual void setGlobalChanged(bool globalChanged){
		globalChanged_ = globalChanged;
	}

	//--------------------------------------------------------------------------
	// e
	//--------------------------------------------------------------------------
	/**
	 * e̐ݒ
	 * @param parent ݒ肷e
	 */
	virtual void setParent(CollisionNode* parent){
		Assert(parent != NULL);
		Assert(parent_ == NULL);
		parent_ = parent;
		setChanged(true);
		// globalEnabled_NodeLeafŐݒ肷
	}

	/**
	 * e̍폜
	 * @param parent 폜e
	 */
	virtual void removeParent(CollisionNode* parent){
		Assert(parent_ != NULL);
		Assert(parent_ == parent);
		parent_ = NULL;
		setChanged(true);
		// globalEnabled_NodeLeafŐݒ肷
	}

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	CollisionObject(const CollisionObject& copy);

	// Rs[̉B
	void operator =(const CollisionObject& copy);

	//--------------------------------------------------------------------------
	// O
	String name_;
	// V[
	CollisionScene* scene_;
	// e
	CollisionNode* parent_;
	// [Uf[^
	void* userData_;
	// LAtO
	bool enabled_;
	// O[oł̗LtO
	bool globalEnabled_;
	// ύXtO
	bool changed_;
	// O[oł̕ύXtO
	bool globalChanged_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of COLLISION_OBJECT_H_
//------------------------------------------------------------------------------
