//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * RWm[hwb_
 * @author Junpee
 */

#ifndef COLLISION_NODE_H_
#define COLLISION_NODE_H_

#include <Collision/System/CollisionObject.h>
#include <Core/Primitive/Axis3.h>
#include <Core/Container/ArrayList.h>

namespace Lamp{

class CollisionLeaf;

//------------------------------------------------------------------------------
/**
 * RWm[h
 */
class CollisionNode : public CollisionObject{
friend class CollisionScene;
public:
	//--------------------------------------------------------------------------
	// XP[
	//--------------------------------------------------------------------------
	/**
	 * XP[̐ݒ
	 * @param scale XP[
	 */
	virtual void setScale(const Vector3& scale){ axis_.setScale(scale); }

	/**
	 * XP[̎擾
	 * @return XP[
	 */
	virtual const Vector3& getScale() const{ return axis_.getScale(); }

	/**
	 * XP[gpĂ邩
	 * @return XP[gpĂȂtrue
	 */
	virtual bool isScaled() const{ return axis_.isScaled(); }

	/**
	 * O[oŃXP[gpĂ邩
	 * @return O[oŃXP[gpĂȂtrue
	 */
	virtual bool isGlobalScaled() const{ return globalScaled_; }

	//--------------------------------------------------------------------------
	// ]
	//--------------------------------------------------------------------------
	/**
	 * XYZ]̐ݒ
	 * @param rotation XYZ]
	 */
	virtual void setRotationXYZ(const Vector3& rotation){
		axis_.setRotationXYZ(rotation);
	}

	/**
	 * XYZ]̎擾
	 * @return XYZ]
	 */
	virtual const Vector3& getRotationXYZ(){ return axis_.getRotationXYZ(); }

	//--------------------------------------------------------------------------
	/**
	 * l]̐ݒ
	 * @param rotation l]
	 */
	virtual void setRotationQuaternion(const Quaternion& rotation){
		axis_.setRotationQuaternion(rotation);
	}

	/**
	 * l]̎擾
	 * @return l]
	 */
	virtual const Quaternion& getRotationQuaternion(){
		return axis_.getRotationQuaternion();
	}

	//--------------------------------------------------------------------------
	// ړ
	//--------------------------------------------------------------------------
	/**
	 * ړ̐ݒ
	 * @param translation ړ
	 */
	virtual void setTranslation(const Vector3& translation){
		axis_.setTranslation(translation);
	}

	/**
	 * ړ̎擾
	 * @return ړ
	 */
	virtual const Vector3& getTranslation() const{
		return axis_.getTranslation();
	}

	//--------------------------------------------------------------------------
	// s
	//--------------------------------------------------------------------------
	/**
	 * [hs̎擾
	 * @return [hs
	 */
	const Matrix34& getWorldMatrix() const{ return worldMatrix_; }

	/**
	 * [Js̎擾
	 * @return [Js
	 */
	const Matrix34& getLocalMatrix() const{ return axis_.getMatrix(); }

	//--------------------------------------------------------------------------
	// qC^[tF[X
	//--------------------------------------------------------------------------
	/**
	 * q̒ǉ
	 * @param child ǉq
	 */
	virtual void addChild(CollisionObject* child){
		child->setParent(this);
		children_.add(child);
	}

	/**
	 * q̍폜
	 * @param child 폜q
	 */
	virtual void removeChild(CollisionObject* child){
		child->removeParent(this);
		children_.removeByValue(child);
	}

	/**
	 * q̎擾
	 * @return q
	 */
	virtual int getChildCount() const{ return children_.getCount(); }

	/**
	 * q̎擾
	 * @param index CfbNX
	 * @return q
	 */
	virtual CollisionObject* getChild(int index) const{
		Assert(index >= 0);
		Assert(index < getChildCount());
		return children_.get(index);
	}

	//--------------------------------------------------------------------------
	// Rs[
	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @return Rs[ꂽRWIuWFNg
	 */
	virtual CollisionObject* copy() const{ return copyCollisionNode(); }

	/**
	 * RWm[h̃Rs[
	 * @return Rs[ꂽRWm[h
	 */
	virtual CollisionNode* copyCollisionNode() const;

	//--------------------------------------------------------------------------
	/**
	 * ċAIj
	 * @param collisionNode jRWm[h
	 * @return jIuWFNg
	 */
	static int recursiveDestroy(CollisionNode* collisionNode);

	/**
	 * q̍ċAIj
	 * @param collisionNode qjRWm[h
	 * @return jIuWFNg
	 */
	static int recursiveDestroyChildren(CollisionNode* collisionNode);

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * RWm[hǂ
	 * @return RWm[hȂtrue
	 */
	virtual bool isCollisionNode() const{ return true; }

protected:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	CollisionNode(const String& name, CollisionScene* scene);

	/**
	 * fXgN^
	 */
	virtual ~CollisionNode();

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param parentMatrix es
	 * @param parentEnabled eL
	 * @param parentScaled eXP[gpĂ邩
	 * @param parentChanged eɕύX
	 */
	virtual void traverseImplement(const Matrix34& parentMatrix,
		bool parentEnabled, bool parentScaled, bool parentChanged);

	//--------------------------------------------------------------------------
	// e
	//--------------------------------------------------------------------------
	/**
	 * e̐ݒ
	 * @param parent ݒ肷e
	 */
	virtual void setParent(CollisionNode* parent){
		CollisionObject::setParent(parent);
		setGlobalEnabled(true);
	}

	/**
	 * e̍폜
	 * @param parent 폜e
	 */
	virtual void removeParent(CollisionNode* parent){
		CollisionObject::removeParent(parent);
		setGlobalEnabled(true);
	}

	//--------------------------------------------------------------------------
	// ύXtO
	//--------------------------------------------------------------------------
	/**
	 * ύXtO̎擾
	 * @return ύXĂtrue
	 */
	virtual bool isChanged() const{
		return (CollisionObject::isChanged() || axis_.isChanged());
	}

	//--------------------------------------------------------------------------
	// XP[
	//--------------------------------------------------------------------------
	/**
	 * O[oŃXP[gpĂ邩̐ݒ
	 * @param globalScaled O[oŃXP[gpĂȂtrue
	 */
	virtual void setGlobalScaled(bool globalScaled){
		globalScaled_ = globalScaled;
	}

private:
	//--------------------------------------------------------------------------
	// [hs
	Matrix34 worldMatrix_;
	// 
	Axis3 axis_;
	// qz
	ArrayList<CollisionObject*> children_;
	// O[oł̃XP[tO
	bool globalScaled_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of COLLISION_NODE_H_
//------------------------------------------------------------------------------
