//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * RW[twb_
 * @author Junpee
 */

#ifndef COLLISION_LEAF_H_
#define COLLISION_LEAF_H_

#include <Collision/System/CollisionObject.h>

namespace Lamp{

class IntersectionResult;

//------------------------------------------------------------------------------
/**
 * RW[t
 */
class CollisionLeaf : public CollisionObject{
friend class CollisionScene;
public:
	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param result 
	 * @param sphere 
	 * @param collisionMask RW}XN
	 */
	virtual void intersection(IntersectionResult* result, const Sphere& sphere,
		u_int collisionMask = 0xffffffff){ Assert(false); }

	/**
	 * RW
	 * @param result 
	 * @param sphere RW
	 * @param collisionMask RW}XN
	 */
	virtual void intersection(IntersectionResult* result,
		StaticSphereCollision* sphere, u_int collisionMask = 0xffffffff){
		Assert(false);
	}

	//--------------------------------------------------------------------------
	// Փ
	//--------------------------------------------------------------------------
	// C^[tF[X

	//--------------------------------------------------------------------------
	// RW}XN
	//--------------------------------------------------------------------------
	/**
	 * RW}XN̐ݒ
	 * @param collisionMask RW}XN
	 */
	virtual void setCollisionMask(u_int collisionMask){
		collisionMask_ = collisionMask;
	}

	/**
	 * RW}XN̎擾
	 * @return RW}XN
	 */
	virtual u_int getCollisionMask() const{ return collisionMask_; }

	//--------------------------------------------------------------------------
	// XP[
	//--------------------------------------------------------------------------
	/**
	 * XP[̐ݒ
	 * @param scale ẽXP[
	 */
	virtual void setScale(const Vector3& scale);

	/**
	 * XP[̎擾
	 * @return ẽXP[
	 */
	virtual const Vector3& getScale() const;

	/**
	 * XP[gpĂ邩
	 * @return eXP[gpĂȂtrue
	 */
	virtual bool isScaled() const;

	/**
	 * O[oŃXP[gpĂ邩
	 * @return eO[oŃXP[gpĂȂtrue
	 */
	virtual bool isGlobalScaled() const;

	//--------------------------------------------------------------------------
	// ]
	//--------------------------------------------------------------------------
	/**
	 * XYZ]̐ݒ
	 * @param rotation eXYZ]
	 */
	virtual void setRotationXYZ(const Vector3& rotation);

	/**
	 * XYZ]̎擾
	 * @return eXYZ]
	 */
	virtual const Vector3& getRotationXYZ();

	//--------------------------------------------------------------------------
	/**
	 * l]̐ݒ
	 * @param rotation e̎l]
	 */
	virtual void setRotationQuaternion(const Quaternion& rotation);

	/**
	 * l]̎擾
	 * @return e̎l]
	 */
	virtual const Quaternion& getRotationQuaternion();

	//--------------------------------------------------------------------------
	// ړ
	//--------------------------------------------------------------------------
	/**
	 * ړ̐ݒ
	 * @param translation ëړ
	 */
	virtual void setTranslation(const Vector3& translation);

	/**
	 * ړ̎擾
	 * @return ëړ
	 */
	virtual const Vector3& getTranslation() const;

	//--------------------------------------------------------------------------
	// s
	//--------------------------------------------------------------------------
	/**
	 * [hs̎擾
	 * @return ẽ[hs
	 */
	const Matrix34& getWorldMatrix() const;

	/**
	 * [Js̎擾
	 * @return ẽ[Js
	 */
	const Matrix34& getLocalMatrix() const;

	//--------------------------------------------------------------------------
	// Rs[
	//--------------------------------------------------------------------------
	/**
	 * RW[t̃Rs[
	 * @return Rs[ꂽRW[t
	 */
	virtual CollisionLeaf* copyCollisionLeaf() const = 0;

	//--------------------------------------------------------------------------
	/**
	 * j
	 * @param collisionLeaf jRW[t
	 * @return jIuWFNg
	 */
	static int destroy(CollisionLeaf* collisionLeaf);

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * RW[tǂ
	 * @return RW[tȂtrue
	 */
	virtual bool isCollisionLeaf() const{ return true; }

protected:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	CollisionLeaf(const String& name, CollisionScene* scene);

	/**
	 * fXgN^
	 */
	virtual ~CollisionLeaf();

	//--------------------------------------------------------------------------
	// Rs[
	//--------------------------------------------------------------------------
	/**
	 * RW[t̒lRs[
	 * @param destination Rs[RW[t
	 */
	virtual void copyCollisionLeafValue(CollisionLeaf* destination) const{
		// RWIuWFNg̒lRs[
		copyCollisionObjectValue(destination);
		// oRs[
		destination->collisionMask_ = collisionMask_;
	}

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ̃ZbgAbv
	 * @param parentEnabled eL
	 * @param parentChanged eɕύX
	 * @return ̑sKvłtrue
	 */
	virtual bool traverseSetup(bool parentEnabled, bool parentChanged);

	//--------------------------------------------------------------------------
	// e
	//--------------------------------------------------------------------------
	/**
	 * e̐ݒ
	 * @param parent ݒ肷e
	 */
	virtual void setParent(CollisionNode* parent){
		CollisionObject::setParent(parent);
		setGlobalEnabled(false);
	}

	/**
	 * e̍폜
	 * @param parent 폜e
	 */
	virtual void removeParent(CollisionNode* parent){
		CollisionObject::removeParent(parent);
		setGlobalEnabled(false);
	}

private:
	//--------------------------------------------------------------------------
	// RW}XN
	u_int collisionMask_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of COLLISION_LEAF_H_
//------------------------------------------------------------------------------
