//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * RW_wb_
 * @author Junpee
 */

#ifndef COLLISION_RENDERER_H_
#define COLLISION_RENDERER_H_

namespace Lamp{

class PrimitiveRenderer;
class Camera;
class CollisionScene;
class StaticSphereCollision;
class StaticDeformedMeshCollision;

//------------------------------------------------------------------------------
/**
 * RW_
 */
class CollisionRenderer{
public:
	/**
	 * RXgN^
	 */
	CollisionRenderer();

	/**
	 * fXgN^
	 */
	virtual ~CollisionRenderer();

	//--------------------------------------------------------------------------
	// _O
	//--------------------------------------------------------------------------
	/**
	 * _Os
	 * @param scene _OsRWV[
	 * @param camera _OɎgpJ
	 */
	virtual void renderingSetup(CollisionScene* scene, Camera* camera);

	//--------------------------------------------------------------------------
	// _O
	//--------------------------------------------------------------------------
	/**
	 * _Os
	 */
	virtual void rendering();

	//--------------------------------------------------------------------------
	// `tO
	//--------------------------------------------------------------------------
	/**
	 * m[h̕`tOݒ
	 * @param isDrawnNode m[h`悷Ȃtrue
	 */
	virtual void setDrawnNode(bool isDrawnNode){ isDrawnNode_ = isDrawnNode; }

	/**
	 * m[h`悷邩
	 * @return m[h`悷Ȃtrue
	 */
	virtual bool isDrawnNode() const{ return isDrawnNode_; }

	//--------------------------------------------------------------------------
	/**
	 * [t̕`tOݒ
	 * @param isDrawnLeaf [t`悷Ȃtrue
	 */
	virtual void setDrawnLeaf(bool isDrawnLeaf){ isDrawnLeaf_ = isDrawnLeaf; }

	/**
	 * [t`悷邩
	 * @return [t`悷Ȃtrue
	 */
	virtual bool isDrawnLeaf() const{ return isDrawnLeaf_; }

protected:
	//--------------------------------------------------------------------------
	/**
	 * ÓIRW̃ZbgAbv
	 * @param sphereCollision ÓIRW
	 */
	virtual void setupStaticSphereCollision(
		StaticSphereCollision* sphereCollision);

	/**
	 * ÓIό`bVRW̃ZbgAbv
	 * @param meshCollision ÓIό`bVRW
	 */
	virtual void setupStaticDeformedMeshCollision(
		StaticDeformedMeshCollision* meshCollision);

	//--------------------------------------------------------------------------
	/// v~eBu_
	PrimitiveRenderer* renderer_;
	/// V[
	CollisionScene* scene_;
	/// J
	Camera* camera_;
	/// m[h`悷邩
	bool isDrawnNode_;
	/// [t`悷邩
	bool isDrawnLeaf_;

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	CollisionRenderer(const CollisionRenderer& copy);

	// Rs[̉B
	void operator =(const CollisionRenderer& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of COLLISION_RENDERER_H_
//------------------------------------------------------------------------------
