//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ÓIRWwb_
 * @author Junpee
 */

#ifndef STATIC_SPHERE_COLLISION_H_
#define STATIC_SPHERE_COLLISION_H_

#include <Collision/System/StaticCollisionLeaf.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * ÓIRW
 */
class StaticSphereCollision : public StaticCollisionLeaf{
friend class CollisionScene;
public:
	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param result 
	 * @param sphere 
	 * @param collisionMask RW}XN
	 */
	virtual void intersection(IntersectionResult* result, const Sphere& sphere,
		u_int collisionMask = 0xffffffff);

	/**
	 * RW
	 * @param result 
	 * @param sphere RW
	 * @param collisionMask RW}XN
	 */
	virtual void intersection(IntersectionResult* result,
		StaticSphereCollision* sphere, u_int collisionMask = 0xffffffff);

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ̐ݒ
	 * @param sphere ݒ肷鋅
	 */
	inline void setSphere(const Sphere& sphere){
		sphere_ = sphere;
		setChanged(true);
	}

	/**
	 * ̐ݒ
	 * @param center ݒ肷钆S
	 * @param radius ݒ肷锼a
	 */
	inline void setSphere(const Vector3& center, float radius){
		sphere_.set(center, radius);
		setChanged(true);
	}

	/**
	 * ̎擾
	 * @return [JW̋
	 */
	virtual const Sphere& getSphere() const{ return sphere_; }

	//--------------------------------------------------------------------------
	/**
	 * [h̎擾
	 * @return [hW̋
	 */
	virtual const Sphere& getWorldSphere(){
		Assert(isGlobalEnabled());
		return worldSphere_;
	}

	//--------------------------------------------------------------------------
	/**
	 * S̐ݒ
	 * @param center ݒ肷钆S
	 */
	inline void setCenter(const Vector3& center){
		sphere_.setCenter(center);
		setChanged(true);
	}

	/**
	 * S̎擾
	 * @return S
	 */
	inline const Vector3& getCenter() const{ return sphere_.getCenter(); }

	//--------------------------------------------------------------------------
	/**
	 * a̐ݒ
	 * @param radius ݒ肷锼a
	 */
	inline void setRadius(float radius){
		sphere_.setRadius(radius);
		setChanged(true);
	}

	/**
	 * a̎擾
	 * @return a
	 */
	inline float getRadius() const{ return sphere_.getRadius(); }

	//--------------------------------------------------------------------------
	// Rs[
	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @return Rs[ꂽRWIuWFNg
	 */
	virtual CollisionObject* copy() const{
		return copyStaticSphereCollision();
	}

	/**
	 * RW[t̃Rs[
	 * @return Rs[ꂽRW[t
	 */
	virtual CollisionLeaf* copyCollisionLeaf() const{
		return copyStaticSphereCollision();
	}

	/**
	 * ÓIRW[t̃Rs[
	 * @return Rs[ꂽÓIRW[t
	 */
	virtual StaticCollisionLeaf* copyStaticCollisionLeaf() const{
		return copyStaticSphereCollision();
	}

	/**
	 * ÓIRW̃Rs[
	 * @return Rs[ꂽÓIRW
	 */
	virtual StaticSphereCollision*
		copyStaticSphereCollision() const;

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * ÓIRWǂ
	 * @return ÓIRWȂtrue
	 */
	virtual bool isStaticSphereCollision() const{ return true; }

protected:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	StaticSphereCollision(const String& name, CollisionScene* scene);

	/**
	 * fXgN^
	 */
	virtual ~StaticSphereCollision();

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param parentMatrix es
	 * @param parentEnabled eL
	 * @param parentScaled eXP[gpĂ邩
	 * @param parentChanged eɕύX
	 */
	virtual void traverseImplement(const Matrix34& parentMatrix,
		bool parentEnabled, bool parentScaled, bool parentChanged);

private:
	//--------------------------------------------------------------------------
	// 
	Sphere sphere_;
	// [h
	Sphere worldSphere_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of STATIC_SPHERE_COLLISION_H_
//------------------------------------------------------------------------------
