//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * ÓIό`bVRWwb_
 * @author Junpee
 */

#ifndef STATIC_DEFORMED_MESH_COLLISION_H_
#define STATIC_DEFORMED_MESH_COLLISION_H_

#include <Collision/System/StaticCollisionLeaf.h>
#include <Geometry/Mesh/DeformedMeshGeometry.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * ÓIό`bVRW
 */
class StaticDeformedMeshCollision : public StaticCollisionLeaf{
friend class CollisionScene;
public:
	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param result 
	 * @param sphere 
	 * @param collisionMask RW}XN
	 */
	virtual void intersection(IntersectionResult* result, const Sphere& sphere,
		u_int collisionMask = 0xffffffff);

	/**
	 * RW
	 * @param result 
	 * @param sphere RW
	 * @param collisionMask RW}XN
	 */
	virtual void intersection(IntersectionResult* result,
		StaticSphereCollision* sphere, u_int collisionMask = 0xffffffff);

	//--------------------------------------------------------------------------
	// bV
	//--------------------------------------------------------------------------
	/**
	 * bV̎擾
	 * @return [JW̃bV
	 */
	virtual const DeformedMeshGeometry& getMesh() const{ return mesh_; }

	/**
	 * [hbV̎擾
	 *
	 * [hbV̎擾s_ŃbV[hWɕϊ
	 * @return [hW̃bV
	 */
	virtual const DeformedMeshGeometry& getWorldMesh();

	//--------------------------------------------------------------------------
	// gCAO
	//--------------------------------------------------------------------------
	/**
	 * gCAO̐ݒ
	 * @param triangleCount gCAO
	 */
	virtual void setTriangleCount(int triangleCount){
		mesh_.setTriangleCount(triangleCount);
		worldMesh_.setTriangleCount(triangleCount);
		setChanged(true);
	}

	/**
	 * gCAO̎擾
	 * @return gCAO
	 */
	virtual int getTriangleCount() const{ return mesh_.getTriangleCount(); }

	//--------------------------------------------------------------------------
	/**
	 * gCAO̐ݒ
	 * @param index CfbNX
	 * @param triangle gCAO
	 */
	virtual void setTriangle(int index, const Triangle& triangle){
		mesh_.setTriangle(index, triangle);
		setChanged(true);
	}

	/**
	 * gCAO̎擾
	 * @param index CfbNX
	 * @return gCAO
	 */
	virtual const Triangle& getTriangle(int index) const{
		return mesh_.getTriangle(index);
	}

	//--------------------------------------------------------------------------
	// oEfBO
	//--------------------------------------------------------------------------
	/**
	 * oEfBO̎Zo
	 */
	virtual void calculateBounding(){
		mesh_.calculateBounding();
		setChanged(true);
	}

	//--------------------------------------------------------------------------
	/**
	 * oEfBO{bNX̐ݒ
	 * @param boundingBox oEfBO{bNX
	 */
	virtual void setBoundingBox(const AxisAlignedBox& boundingBox){
		mesh_.setBoundingBox(boundingBox);
		setChanged(true);
	}

	/**
	 * oEfBO{bNX̎擾
	 * @return oEfBO{bNX
	 */
	virtual const AxisAlignedBox& getBoundingBox() const{
		return mesh_.getBoundingBox();
	}

	//--------------------------------------------------------------------------
	/**
	 * oEfBOXtBA̐ݒ
	 * @param boundingSphere oEfBOXtBA
	 */
	virtual void setBoundingSphere(const Sphere& boundingSphere){
		mesh_.setBoundingSphere(boundingSphere);
		setChanged(true);
	}

	/**
	 * oEfBOXtBA̎擾
	 * @return oEfBOXtBA
	 */
	virtual const Sphere& getBoundingSphere() const{
		return mesh_.getBoundingSphere();
	}

	//--------------------------------------------------------------------------
	// Rs[
	//--------------------------------------------------------------------------
	/**
	 * Rs[
	 * @return Rs[ꂽRWIuWFNg
	 */
	virtual CollisionObject* copy() const{
		return copyStaticDeformedMeshCollision();
	}

	/**
	 * RW[t̃Rs[
	 * @return Rs[ꂽRW[t
	 */
	virtual CollisionLeaf* copyCollisionLeaf() const{
		return copyStaticDeformedMeshCollision();
	}

	/**
	 * ÓIRW[t̃Rs[
	 * @return Rs[ꂽÓIRW[t
	 */
	virtual StaticCollisionLeaf* copyStaticCollisionLeaf() const{
		return copyStaticDeformedMeshCollision();
	}

	/**
	 * ÓIό`bVRW̃Rs[
	 * @return Rs[ꂽÓIό`bVRW
	 */
	virtual StaticDeformedMeshCollision*
		copyStaticDeformedMeshCollision() const;

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * ÓIό`bVRWǂ
	 * @return ÓIό`bVRWȂtrue
	 */
	virtual bool isStaticDeformedMeshCollision() const{ return true; }

protected:
	//--------------------------------------------------------------------------
	// Aj
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 * @param name O
	 * @param scene V[
	 */
	StaticDeformedMeshCollision(const String& name, CollisionScene* scene);

	/**
	 * fXgN^
	 */
	virtual ~StaticDeformedMeshCollision();

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param parentMatrix es
	 * @param parentEnabled eL
	 * @param parentScaled eXP[gpĂ邩
	 * @param parentChanged eɕύX
	 */
	virtual void traverseImplement(const Matrix34& parentMatrix,
		bool parentEnabled, bool parentScaled, bool parentChanged);

private:
	//--------------------------------------------------------------------------
	// bV
	DeformedMeshGeometry mesh_;
	// [hbV
	DeformedMeshGeometry worldMesh_;
	// [hbVύXtO
	bool worldMeshChanged_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of STATIC_DEFORMED_MESH_COLLISION_H_
//------------------------------------------------------------------------------
