//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eLXgRWZ[owb_
 * @author Junpee
 */

#ifndef TEXT_COLLISION_SAVER_H_
#define TEXT_COLLISION_SAVER_H_

namespace Lamp{

class TextWriter;
class CollisionScene;
class CollisionNode;
class CollisionLeaf;
class StaticSphereCollision;
class StaticDeformedMeshCollision;

//------------------------------------------------------------------------------
/**
 * eLXgRWZ[o
 */
class TextCollisionSaver{
public:
	/**
	 * RXgN^
	 */
	TextCollisionSaver();

	/**
	 * fXgN^
	 */
	virtual ~TextCollisionSaver();

	/**
	 * Z[u
	 * @param filePath t@CpX
	 * @param scene Z[uV[
	 */
	virtual void save(const String& filePath, CollisionScene* scene);

	/**
	 * Z[u
	 * @param textWriter eLXgC^
	 * @param scene Z[uV[
	 * @param basePath x[XpX
	 */
	virtual void save(TextWriter* textWriter, CollisionScene* scene);

protected:
	//--------------------------------------------------------------------------
	/**
	 * wb_̏o
	 */
	virtual void writeHeader();

	/**
	 * RWm[h̏o
	 * @param node oRWm[h
	 */
	virtual void writeCollisionNode(CollisionNode* node);

	//--------------------------------------------------------------------------
	// [t
	//--------------------------------------------------------------------------
	/**
	 * RW[t̏o
	 * @param leaf oRW[t
	 * @param type [t^Cv
	 */
	virtual void writeCollisionLeaf(CollisionLeaf* leaf, const String& type);

	/**
	 * ÓIRW̏o
	 * @param sphere oÓIRW
	 */
	virtual void writeStaticSphereCollision(StaticSphereCollision* sphere);

	/**
	 * ÓIό`bVRW̏o
	 * @param mesh oÓIό`bVRW
	 */
	virtual void writeStaticDeformedMeshCollision(
		StaticDeformedMeshCollision* mesh);

	//--------------------------------------------------------------------------
	// N
	//--------------------------------------------------------------------------
	/**
	 * RWm[hN̏o
	 * @param node oRWm[h
	 */
	virtual void writeCollisionNodeLink(CollisionNode* node);

	//--------------------------------------------------------------------------
	// [eBeB
	//--------------------------------------------------------------------------
	/**
	 * bool̏o
	 */
	virtual void writeBool(bool);

	/**
	 * Rg̏o
	 */
	virtual void writeLineComment();

	/**
	 * ubNRg̏o
	 * @param blockName ubN
	 */
	virtual void writeBlockComment(const String& blockName);

	//--------------------------------------------------------------------------
	// o
	//--------------------------------------------------------------------------
	/// C^
	TextWriter* writer_;
	/// V[
	CollisionScene* scene_;

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	TextCollisionSaver(const TextCollisionSaver& copy);

	// Rs[̉B
	void operator =(const TextCollisionSaver& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of TEXT_COLLISION_SAVER_H_
//------------------------------------------------------------------------------
