//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * eLXgRW[_wb_
 * @author Junpee
 */

#ifndef TEXT_COLLISION_LOADER_H_
#define TEXT_COLLISION_LOADER_H_

namespace Lamp{

class TextReader;
class StreamTokenizer;
class CollisionScene;
class CollisionNode;

//------------------------------------------------------------------------------
/**
 * eLXgRW[_
 */
class TextCollisionLoader{
public:
	/**
	 * RXgN^
	 */
	TextCollisionLoader();

	/**
	 * fXgN^
	 */
	virtual ~TextCollisionLoader();

	//--------------------------------------------------------------------------
	/**
	 * [h
	 * @param filePath t@CpX
	 * @param scene [hV[
	 */
	virtual void load(const String& filePath, CollisionScene* scene);

	/**
	 * [h
	 * @param filePath t@CpX
	 * @param scene [hV[
	 * @param node [hm[h
	 */
	virtual void load(const String& filePath, CollisionScene* scene,
		CollisionNode* node);

	/**
	 * [h
	 * @param textReader eLXg[_
	 * @param scene [hV[
	 */
	virtual void load(TextReader* textReader, CollisionScene* scene);

	/**
	 * [h
	 * @param textReader eLXg[_
	 * @param scene [hV[
	 * @param node [hm[h
	 */
	virtual void load(TextReader* textReader, CollisionScene* scene,
		CollisionNode* node);

protected:
	//--------------------------------------------------------------------------
	/**
	 * wb_̓ǂݍ
	 */
	virtual void readHeader();

	//--------------------------------------------------------------------------
	// RWm[h
	//--------------------------------------------------------------------------
	/**
	 * RWm[hXg̓ǂݍ
	 */
	virtual void readCollisionNodeList();

	/**
	 * RWm[h̓ǂݍ
	 * @param name O
	 */
	virtual void readCollisionNode(const String& name);

	//--------------------------------------------------------------------------
	// RW[t
	//--------------------------------------------------------------------------
	/**
	 * RW[tXg̓ǂݍ
	 */
	virtual void readCollisionLeafList();

	/**
	 * ÓIRW̓ǂݍ
	 * @param name O
	 */
	virtual void readStaticSphere(const String& name);

	/**
	 * ÓIό`bVRW̓ǂݍ
	 * @param name O
	 */
	virtual void readStaticDeformedMesh(const String& name);

	//--------------------------------------------------------------------------
	// RWN
	//--------------------------------------------------------------------------
	/**
	 * RWNXg̓ǂݍ
	 */
	virtual void readCollisionLinkList();

	/**
	 * RWN̓ǂݍ
	 * @param name O
	 */
	virtual void readCollisionLink(const String& name);

	//--------------------------------------------------------------------------
	// l̓ǂݍ
	//--------------------------------------------------------------------------
	/**
	 * booll̓ǂݍ
	 * @return booll
	 */
	virtual bool readBool();

	/**
	 * intl̓ǂݍ
	 * @return intl
	 */
	virtual int readInt();

	/**
	 * u_intl̓ǂݍ
	 * @return u_intl
	 */
	virtual u_int readUInt();

	/**
	 * floatl̓ǂݍ
	 * @return floatl
	 */
	virtual float readFloat();

	/**
	 * Vector3l̓ǂݍ
	 * @return Vector3l
	 */
	virtual Vector3 readVector3();

	/**
	 * {bNX̓ǂݍ
	 * @return {bNX
	 */
	virtual AxisAlignedBox readAxisAlignedBox();

	/**
	 * ̓ǂݍ
	 * @return 
	 */
	virtual Sphere readSphere();

	/**
	 * Op̓ǂݍ
	 * @return Op
	 */
	virtual Triangle readTriangle();

	//--------------------------------------------------------------------------
	// [eBeB
	//--------------------------------------------------------------------------
	/**
	 * g[N̓ǂݍ
	 * @param caller Ăяo
	 */
	virtual String readToken(const String& caller);

	/**
	 * w胏[h̓ǂݔ΂
	 * @param word ǂݔ΂[h
	 */
	virtual void skipWord(const String& word);

	/**
	 * `NJ
	 */
	virtual void openChunk(){ skipWord("{"); }

	/**
	 * `N
	 */
	virtual void closeChunk(){ skipWord("}"); }

	/**
	 * `N̓ǂݔ΂
	 */
	virtual void skipChunk();

	//--------------------------------------------------------------------------
	// o
	//--------------------------------------------------------------------------
	/// g[NiCU
	StreamTokenizer* tokenizer_;
	/// V[
	CollisionScene* scene_;
	/// [gm[h
	CollisionNode* rootNode_;

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	TextCollisionLoader(const TextCollisionLoader& copy);

	// Rs[̉B
	void operator =(const TextCollisionLoader& copy);

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of TEXT_COLLISION_LOADER_H_
//------------------------------------------------------------------------------
