//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * RWRo[^wb_
 * @author Junpee
 */

#ifndef COLLISION_CONVERTER_H_
#define COLLISION_CONVERTER_H_

namespace Lamp{

class Scene;
class SceneNode;
class SceneLeaf;
class Mesh;

class CollisionScene;
class CollisionNode;
class CollisionLeaf;

//------------------------------------------------------------------------------
/**
 * RWRo[^
 */
class CollisionConverter{
public:
	/**
	 * RXgN^
	 */
	CollisionConverter();

	/**
	 * fXgN^
	 */
	virtual ~CollisionConverter();

	/**
	 * Ro[g
	 * @param scene Ro[gV[
	 * @param collisionScene Ro[gV[
	 * @return true
	 */
	virtual bool convert(Scene* scene, CollisionScene* collisionScene);

protected:
	/**
	 * m[h̃Ro[g
	 * @param parentCollisionNode eRWm[h
	 * @param sceneNode V[m[h
	 * @return true
	 */
	virtual bool convertNode(
		CollisionNode* parentCollisionNode, SceneNode* sceneNode);

	/**
	 * [t̃Ro[g
	 * @param parentCollisionNode eRWm[h
	 * @param sceneLeaf V[[t
	 * @return true
	 */
	virtual bool convertLeaf(
		CollisionNode* parentCollisionNode, SceneLeaf* sceneLeaf);

	/**
	 * ÓIό`bṼRo[g
	 * @param parentCollisionNode eRWm[h
	 * @param mesh bV
	 * @return true
	 */
	virtual bool convertStaticDeformedMesh(
		CollisionNode* parentCollisionNode, Mesh* mesh);

	/**
	 * RW[tf[^ݒ
	 * @param parentCollisionNode eRWm[h
	 * @param mesh bV
	 * @param collisionLeaf RW[t
	 * @return true
	 */
	virtual bool setCollisionLeafData(CollisionNode* parentCollisionNode,
		Mesh* mesh, CollisionLeaf* collisionLeaf);

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	CollisionConverter(const CollisionConverter& copy);

	// Rs[̉B
	void operator =(const CollisionConverter& copy);

	// RWV[
	CollisionScene* collisionScene_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of COLLISION_CONVERTER_H_
//------------------------------------------------------------------------------
