//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * xNg`ԃwb_
 * @author Junpee
 */

#ifndef VECTOR_LINEAR_INTERPOLATOR_H_
#define VECTOR_LINEAR_INTERPOLATOR_H_

#include <Animation/VectorInterpolator/VectorInterpolator.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * xNg`
 */
class VectorLinearInterpolator : public VectorInterpolator{
public:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	VectorLinearInterpolator();

	/**
	 * fXgN^
	 */
	virtual ~VectorLinearInterpolator();

	/**
	 * Rs[RXgN^
	 * @param copy Rs[
	 */
	explicit VectorLinearInterpolator(const VectorLinearInterpolator& copy);

	/**
	 * Zq
	 * @param copy 
	 */
	virtual VectorLinearInterpolator& operator =(
		const VectorLinearInterpolator& copy);

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return ꂽxNgԁBĂяodeleteKv
	 */
	virtual VectorInterpolator* duplicate() const{
		VectorInterpolator* result = new VectorLinearInterpolator(*this);
		return result;
	}

	//--------------------------------------------------------------------------
	/**
	 * lǂ
	 * @param target rΏ
	 * @return lȂtrue
	 */
	virtual bool equals(const VectorInterpolator& target) const{
		VectorLinearInterpolator* interpolator =
			target.castVectorLinearInterpolator();
		if(interpolator == NULL){ return false; }
		if(keyCount_ != interpolator->keyCount_){ return false; }
		for(int i = 0; i < keyCount_; i++){
			const Key& key = keys_[i];
			const Key& targetKey = interpolator->keys_[i];
			if(key.value_ != targetKey.value_){ return false; }
			if(key.time_ != targetKey.time_){ return false; }
		}
		return true;
	}

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ̎擾
	 * @return 
	 */
	virtual float getLength() const;

	//--------------------------------------------------------------------------
	// oEfBO
	//--------------------------------------------------------------------------
	/**
	 * oEfBO{bNX̎擾
	 * @return oEfBO{bNX
	 */
	virtual AxisAlignedBox getBoundingBox() const;

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param time 
	 * @return ԂꂽxNg
	 */
	virtual Vector3 interpolate(float time);

	//--------------------------------------------------------------------------
	// L[
	//--------------------------------------------------------------------------
	/**
	 * L[̐ݒ
	 * @param keyCount L[
	 */
	virtual void setKeyCount(int keyCount);

	/**
	 * L[̎擾
	 * @return L[
	 */
	virtual int getKeyCount() const{ return keyCount_; }

	//--------------------------------------------------------------------------
	/**
	 * L[̐ݒ
	 * @param index L[CfbNX
	 * @param time 
	 * @param value l
	 */
	virtual void setKey(int index, float time, const Vector3& value){
		Assert((index >= 0) && (index < keyCount_) && (keys_ != NULL));
		Key& key = keys_[index];
		key.value_ = value;
		key.time_ = time;
	}

	/**
	 * l̎擾
	 * @param index L[CfbNX
	 * @return l
	 */
	virtual const Vector3& getValue(int index) const{
		Assert((index >= 0) && (index < keyCount_) && (keys_ != NULL));
		return keys_[index].value_;
	}

	/**
	 * Ԃ̎擾
	 * @param index L[CfbNX
	 * @return 
	 */
	virtual float getTime(int index) const{
		Assert((index >= 0) && (index < keyCount_) && (keys_ != NULL));
		return keys_[index].time_;
	}

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * xNg`Ԃǂ
	 * @return xNg`ԂȂtrue
	 */
	virtual bool isVectorLinearInterpolator() const{ return true; }

	//--------------------------------------------------------------------------
private:
	/// L[
	class Key{
	friend class VectorLinearInterpolator;
	private:
		/// l
		Vector3 value_;
		/// 
		float time_;
	};

	// L[
	Key* keys_;
	// L[̐
	int keyCount_;
	// ŌɎgpL[CfbNX
	int lastestUseKeyIndex_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of VECTOR_LINEAR_INTERPOLATOR_H_
//------------------------------------------------------------------------------
