//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * xNgԃwb_
 * @author Junpee
 */

#ifndef VECTOR_INTERPOLATOR_H_
#define VECTOR_INTERPOLATOR_H_

namespace Lamp{

class VectorConstantInterpolator;
class VectorArrayInterpolator;
class VectorLinearInterpolator;

//------------------------------------------------------------------------------
/**
 * xNg
 *
 * TuNXŃRs[RXgN^ƑZq
 */
class VectorInterpolator{
public:
	//--------------------------------------------------------------------------
	/**
	 * fXgN^
	 */
	virtual ~VectorInterpolator(){}

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return ꂽxNgԁBĂяodeleteKv
	 */
	virtual VectorInterpolator* duplicate() const = 0;

	/**
	 * lǂ
	 * @param target rΏ
	 * @return lȂtrue
	 */
	virtual bool equals(const VectorInterpolator& target) const = 0;

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ̎擾
	 * @return 
	 */
	virtual float getLength() const = 0;

	//--------------------------------------------------------------------------
	// oEfBO
	//--------------------------------------------------------------------------
	/**
	 * oEfBO{bNX̎擾
	 * @return oEfBO{bNX
	 */
	virtual AxisAlignedBox getBoundingBox() const = 0;

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param time 
	 * @return ԂꂽxNg
	 */
	virtual Vector3 interpolate(float time) = 0;

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * xNg萔Ԃǂ
	 * @return xNg萔ԂȂtrue
	 */
	virtual bool isVectorConstantInterpolator() const{ return false; }

	/**
	 * xNg萔Ԃւ̃LXg
	 * @return xNg萔ԁB^ႦNULLԂB
	 */
	virtual VectorConstantInterpolator* castVectorConstantInterpolator() const{
		if(isVectorConstantInterpolator()){
			return (VectorConstantInterpolator*)this;
		}
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * xNgzԂǂ
	 * @return xNgzԂȂtrue
	 */
	virtual bool isVectorArrayInterpolator() const{ return false; }

	/**
	 * xNgzԂւ̃LXg
	 * @return xNgzԁB^ႦNULLԂB
	 */
	virtual VectorArrayInterpolator* castVectorArrayInterpolator() const{
		if(isVectorArrayInterpolator()){
			return (VectorArrayInterpolator*)this;
		}
		return NULL;
	}

	//--------------------------------------------------------------------------
	/**
	 * xNg`Ԃǂ
	 * @return xNg`ԂȂtrue
	 */
	virtual bool isVectorLinearInterpolator() const{ return false; }

	/**
	 * xNg`Ԃւ̃LXg
	 * @return xNg`ԁB^ႦNULLԂB
	 */
	virtual VectorLinearInterpolator* castVectorLinearInterpolator() const{
		if(isVectorLinearInterpolator()){
			return (VectorLinearInterpolator*)this;
		}
		return NULL;
	}

	//--------------------------------------------------------------------------

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of VECTOR_INTERPOLATOR_H_
//------------------------------------------------------------------------------

