//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * xNg萔ԃwb_
 * @author Junpee
 */

#ifndef VECTOR_CONSTANT_INTERPOLATOR_H_
#define VECTOR_CONSTANT_INTERPOLATOR_H_

#include <Animation/VectorInterpolator/VectorInterpolator.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * xNg萔
 */
class VectorConstantInterpolator : public VectorInterpolator{
public:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	VectorConstantInterpolator() : value_(Vector3::zero), length_(0.f){}

	/**
	 * fXgN^
	 */
	virtual ~VectorConstantInterpolator(){}

	/**
	 * Rs[RXgN^
	 * @param copy Rs[
	 */
	explicit VectorConstantInterpolator(
		const VectorConstantInterpolator& copy){
		value_ = copy.value_;
		length_ = copy.length_;
	}

	/**
	 * Zq
	 * @param copy 
	 */
	virtual VectorConstantInterpolator& operator =(
		const VectorConstantInterpolator& copy){
		// gȂ烊^[
		if(this == &copy){ return *this; }
		value_ = copy.value_;
		length_ = copy.length_;
		return *this;
	}

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return ꂽxNgԁBĂяodeleteKv
	 */
	virtual VectorInterpolator* duplicate() const{
		VectorInterpolator* result = new VectorConstantInterpolator(*this);
		return result;
	}

	//--------------------------------------------------------------------------
	/**
	 * lǂ
	 * @param target rΏ
	 * @return lȂtrue
	 */
	virtual bool equals(const VectorInterpolator& target) const{
		VectorConstantInterpolator* interpolator =
			target.castVectorConstantInterpolator();
		if(interpolator == NULL){ return false; }
		return ((value_ == interpolator->value_) &&
			(length_ == interpolator->length_));
	}

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ̎擾
	 * @return 
	 */
	virtual float getLength() const{ return length_; }

	/**
	 * ̐ݒ
	 * @param length 
	 */
	virtual void setLength(float length){
		Assert(length >= 0.f);
		length_ = length;
	}

	//--------------------------------------------------------------------------
	// oEfBO
	//--------------------------------------------------------------------------
	/**
	 * oEfBO{bNX̎擾
	 * @return oEfBO{bNX
	 */
	virtual AxisAlignedBox getBoundingBox() const{
		AxisAlignedBox result;
		result.set(value_, value_);
		return result;
	}

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param time 
	 * @return ԂꂽxNg
	 */
	virtual Vector3 interpolate(float time){ return value_; }

	//--------------------------------------------------------------------------
	// l
	//--------------------------------------------------------------------------
	/**
	 * l̐ݒ
	 * @param value ݒ肷l
	 */
	virtual void setValue(const Vector3& value){ value_ = value; }

	/**
	 * l̎擾
	 * @return 擾l
	 */
	virtual Vector3 getValue() const{ return value_; }

	//--------------------------------------------------------------------------
	/**
	 * xNg萔Ԃǂ
	 * @return xNg萔ԂȂtrue
	 */
	virtual bool isVectorConstantInterpolator() const{ return true; }

	//--------------------------------------------------------------------------
private:
	// 萔
	Vector3 value_;
	// 
	float length_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of VECTOR_CONSTANT_INTERPOLATOR_H_
//------------------------------------------------------------------------------

