//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * xNgzԃwb_
 * @author Junpee
 */

#ifndef VECTOR_ARRAY_INTERPOLATOR_H_
#define VECTOR_ARRAY_INTERPOLATOR_H_

#include <Animation/VectorInterpolator/VectorInterpolator.h>

namespace Lamp{

//------------------------------------------------------------------------------
/**
 * xNgz
 */
class VectorArrayInterpolator : public VectorInterpolator{
public:
	//--------------------------------------------------------------------------
	/**
	 * RXgN^
	 */
	VectorArrayInterpolator();

	/**
	 * fXgN^
	 */
	virtual ~VectorArrayInterpolator();

	/**
	 * Rs[RXgN^
	 * @param copy Rs[
	 */
	explicit VectorArrayInterpolator(const VectorArrayInterpolator& copy);

	/**
	 * Zq
	 * @param copy 
	 */
	virtual VectorArrayInterpolator& operator =(
		const VectorArrayInterpolator& copy);

	//--------------------------------------------------------------------------
	/**
	 * 
	 * @return ꂽxNgԁBĂяodeleteKv
	 */
	virtual VectorInterpolator* duplicate() const{
		VectorInterpolator* result = new VectorArrayInterpolator(*this);
		return result;
	}

	//--------------------------------------------------------------------------
	/**
	 * lǂ
	 * @param target rΏ
	 * @return lȂtrue
	 */
	virtual bool equals(const VectorInterpolator& target) const{
		VectorArrayInterpolator* interpolator =
			target.castVectorArrayInterpolator();
		if(interpolator == NULL){ return false; }
		if(size_ != interpolator->size_){ return false; }
		for(int i = 0; i < size_; i++){
			if(array_[i] != interpolator->array_[i]){ return false; }
		}
		return true;
	}

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * ̎擾
	 * @return 
	 */
	virtual float getLength() const{ return length_; }

	//--------------------------------------------------------------------------
	// oEfBO
	//--------------------------------------------------------------------------
	/**
	 * oEfBO{bNX̎擾
	 * @return oEfBO{bNX
	 */
	virtual AxisAlignedBox getBoundingBox() const;

	//--------------------------------------------------------------------------
	// 
	//--------------------------------------------------------------------------
	/**
	 * 
	 * @param time 
	 * @return ԂꂽxNg
	 */
	virtual Vector3 interpolate(float time);

	//--------------------------------------------------------------------------
	// l
	//--------------------------------------------------------------------------
	/**
	 * TCYݒ
	 * @param size ݒ肷TCYBTCY - 1LengthɂȂB
	 */
	virtual void setSize(int size);

	/**
	 * TCY擾
	 * @return TCY
	 */
	virtual int getSize() const{ return size_; }

	//--------------------------------------------------------------------------
	/**
	 * l̐ݒ
	 * @param time lݒ肷鎞
	 * @param value ݒ肷l
	 */
	virtual void setValue(int time, const Vector3& value){
		Assert((array_ != NULL) && (time >= 0) && (time < size_));
		array_[time] = value;
	}

	/**
	 * l̎擾
	 * @param time l擾鎞
	 * @return l
	 */
	virtual const Vector3& getValue(int time) const{
		Assert((array_ != NULL) && (time >= 0) && (time < size_));
		return array_[time];
	}

	//--------------------------------------------------------------------------
	// RTTI
	//--------------------------------------------------------------------------
	/**
	 * xNgzԂǂ
	 * @return xNgzԂȂtrue
	 */
	virtual bool isVectorArrayInterpolator() const{ return true; }

	//--------------------------------------------------------------------------
private:
	// z
	Vector3* array_;
	// TCY
	int size_;
	// 
	float length_;

};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of VECTOR_ARRAY_INTERPOLATOR_H_
//------------------------------------------------------------------------------

