//------------------------------------------------------------------------------
// Lamp : Open source game middleware
// Copyright (C) 2004  Junpei Ohtani ( Email : junpee@users.sourceforge.jp )
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//------------------------------------------------------------------------------

/** @file
 * Aj[Vkwb_
 * @author Junpee
 */

#ifndef ANIMATION_COMPRESSOR_H_
#define ANIMATION_COMPRESSOR_H_

namespace Lamp{

class VectorInterpolationCompressor;
class VectorInterpolator;
class RotationInterpolationCompressor;
class RotationInterpolator;
class Animation;
class AnimationSet;
class CameraAnimation;
class SceneNodeAnimation;
class CharacterModelAnimation;

//------------------------------------------------------------------------------
/**
 * Aj[Vk 
 */
class AnimationCompressor{
public:
	/**
	 * RXgN^
	 */
	AnimationCompressor();

	/**
	 * fXgN^
	 */
	virtual ~AnimationCompressor();

	//--------------------------------------------------------------------------
	// k
	//--------------------------------------------------------------------------
	/**
	 * k
	 * @param animation kAj[V
	 */
	virtual void compress(Animation* animation);

	//--------------------------------------------------------------------------
	// p[^
	//--------------------------------------------------------------------------
	/**
	 * XP[덷̐ݒ
	 * @param scaleTolerance XP[덷
	 */
	virtual void setScaleTolerance(float scaleTolerance){
		Assert(scaleTolerance >= 0.f)
		scaleTolerance_ = scaleTolerance;
	}

	/**
	 * XP[덷̎擾
	 * @return XP[덷
	 */
	virtual float getScaleTolerance() const{ return scaleTolerance_; }

	//--------------------------------------------------------------------------
	/**
	 * ]덷̐ݒ
	 * @param rotationTolerance ]덷
	 */
	virtual void setRotationTolerance(float rotationTolerance){
		Assert(rotationTolerance >= 0.f)
		rotationTolerance_ = rotationTolerance;
	}

	/**
	 * ]덷̎擾
	 * @return ]덷
	 */
	virtual float getRotationTolerance() const{
		return rotationTolerance_;
	}

	//--------------------------------------------------------------------------
	/**
	 * ړ덷̐ݒ
	 * @param translationTolerance ړ덷
	 */
	virtual void setTranslationTolerance(float translationTolerance){
		Assert(translationTolerance >= 0.f)
		translationTolerance_ = translationTolerance;
	}

	/**
	 * ړ덷̎擾
	 * @return ړ덷
	 */
	virtual float getTranslationTolerance() const{
		return translationTolerance_;
	}

protected:
	//--------------------------------------------------------------------------
	// k
	//--------------------------------------------------------------------------
	/**
	 * Aj[V̈k
	 * @param animation Aj[V
	 */
	virtual void compressAnimation(Animation* animation);

	/**
	 * Aj[VZbg̈k
	 * @param animation Aj[VZbg
	 */
	virtual void compressAnimationSet(AnimationSet* animation);

	/**
	 * JAj[V̈k
	 * @param animation JAj[V
	 */
	virtual void compressCameraAnimation(CameraAnimation* animation);

	/**
	 * V[m[hAj[V̈k
	 * @param animation V[m[hAj[V
	 */
	virtual void compressSceneNodeAnimation(SceneNodeAnimation* animation);

	/**
	 * LN^fAj[V̈k
	 * @param animation LN^fAj[V
	 */
	virtual void compressCharacterModelAnimation(
		CharacterModelAnimation* animation);

	//--------------------------------------------------------------------------
	// [eBeB
	//--------------------------------------------------------------------------
	/**
	 * XP[̈k
	 * @param interpolator XP[
	 */
	virtual VectorInterpolator* compressScale(VectorInterpolator* interpolator);

	/**
	 * ]̈k
	 * @param interpolator ]
	 */
	virtual RotationInterpolator* compressRotation(
		RotationInterpolator* interpolator);

	/**
	 * ړ̈k
	 * @param interpolator ړ
	 */
	virtual VectorInterpolator* compressTranslation(
		VectorInterpolator* interpolator);

private:
	//--------------------------------------------------------------------------
	// Rs[RXgN^̉B
	AnimationCompressor(const AnimationCompressor& copy);

	// Rs[̉B
	void operator =(const AnimationCompressor& copy);

	// XP[덷
	float scaleTolerance_;
	// ]덷
	float rotationTolerance_;
	// ړ덷
	float translationTolerance_;
	// XP[k
	VectorInterpolationCompressor* scaleCompressor_;
	// ]k
	RotationInterpolationCompressor* rotationCompressor_;
	// ړk
	VectorInterpolationCompressor* translationCompressor_;
};

//------------------------------------------------------------------------------
} // End of namespace Lamp
#endif // End of ANIMATION_COMPRESSOR_H_
//------------------------------------------------------------------------------
